/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.internal.cache.backup;

import java.io.File;
import java.io.IOException;
import java.nio.file.Path;
import java.util.Map;
import org.apache.geode.cache.DiskStore;
import org.apache.geode.internal.cache.backup.BackupFilter;
import org.apache.geode.internal.cache.backup.IncrementalBackupLocation;

public class IncrementalBackupFilter
implements BackupFilter {
    private final IncrementalBackupLocation incrementalBackupLocation;

    IncrementalBackupFilter(IncrementalBackupLocation incrementalBackupLocation) {
        this.incrementalBackupLocation = incrementalBackupLocation;
    }

    @Override
    public boolean accept(DiskStore diskStore, Path path) throws IOException {
        Map<String, File> baselineOplogMap = this.incrementalBackupLocation.getBackedUpOplogs(diskStore);
        return !baselineOplogMap.containsKey(path.getFileName().toString());
    }
}

