/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.distributed.internal;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import org.apache.geode.DataSerializer;
import org.apache.geode.distributed.internal.AdminMessageType;
import org.apache.geode.distributed.internal.ClusterDistributionManager;
import org.apache.geode.distributed.internal.HighPriorityDistributionMessage;
import org.apache.geode.distributed.internal.MessageWithReply;
import org.apache.geode.distributed.internal.membership.InternalDistributedMember;
import org.apache.geode.internal.Assert;
import org.apache.geode.internal.serialization.DeserializationContext;
import org.apache.geode.internal.serialization.SerializationContext;

public class ShutdownMessage
extends HighPriorityDistributionMessage
implements AdminMessageType,
MessageWithReply {
    protected InternalDistributedMember id;
    private int processorId;

    void setDistributionManagerId(InternalDistributedMember id) {
        this.id = id;
    }

    @Override
    public boolean sendViaUDP() {
        return true;
    }

    public void setProcessorId(int pid) {
        this.processorId = pid;
    }

    @Override
    public int getProcessorId() {
        return this.processorId;
    }

    @Override
    public boolean getInlineProcess() {
        return false;
    }

    @Override
    protected void process(ClusterDistributionManager dm) {
        Assert.assertTrue(this.id != null);
        dm.shutdownMessageReceived(this.id, "shutdown message received");
    }

    public int getDSFID() {
        return 98;
    }

    @Override
    public void toData(DataOutput out, SerializationContext context) throws IOException {
        super.toData(out, context);
        out.writeInt(this.processorId);
        DataSerializer.writeObject(this.id, out);
    }

    @Override
    public void fromData(DataInput in, DeserializationContext context) throws IOException, ClassNotFoundException {
        super.fromData(in, context);
        this.processorId = in.readInt();
        this.id = (InternalDistributedMember)DataSerializer.readObject(in);
    }

    @Override
    public String toString() {
        return String.format("ShutdownMessage DM %s has shutdown", this.id);
    }
}

