/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.management.internal.cli.commands;

import org.apache.geode.management.cli.CliMetaData;
import org.apache.geode.management.internal.cli.LogWrapper;
import org.apache.geode.management.internal.cli.commands.OfflineGfshCommand;
import org.apache.geode.management.internal.cli.result.model.ResultModel;
import org.springframework.shell.core.annotation.CliCommand;
import org.springframework.shell.core.annotation.CliOption;

public class SleepCommand
extends OfflineGfshCommand {
    @CliCommand(value={"sleep"}, help="Delay for a specified amount of time in seconds - floating point values are allowed.")
    @CliMetaData(shellOnly=true, relatedTopic={"GFSH"})
    public ResultModel sleep(@CliOption(key={"time"}, unspecifiedDefaultValue="3", help="Number of Seconds to sleep for.") double time) {
        try {
            LogWrapper.getInstance().fine("Sleeping for " + time + "seconds.");
            Thread.sleep(Math.round(time * 1000.0));
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        return ResultModel.createInfo("");
    }
}

