<!---
  Licensed to the Apache Software Foundation (ASF) under one
  or more contributor license agreements.  See the NOTICE file
  distributed with this work for additional information
  regarding copyright ownership.  The ASF licenses this file
  to you under the Apache License, Version 2.0 (the
  "License"); you may not use this file except in compliance
  with the License.  You may obtain a copy of the License at

    http://www.apache.org/licenses/LICENSE-2.0

  Unless required by applicable law or agreed to in writing,
  software distributed under the License is distributed on an
  "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
  KIND, either express or implied.  See the License for the
  specific language governing permissions and limitations
  under the License.
-->

# Communication

We welcome participation from everyone and encourage you to join us, ask
questions, and get involved.

All participation in the Apache DataFusion project is governed by the
Apache Software Foundation's [code of
conduct](https://www.apache.org/foundation/policies/conduct.html).

## GitHub

The vast majority of communication occurs in the open on our
[github repository](https://github.com/apache/datafusion) in the form of tickets, issues, discussions, and Pull Requests.

## Slack and Discord

We use the Slack and Discord platforms for informal discussions and coordination. These are great places to
meet other contributors and get guidance on where to contribute. It is important to note that any technical designs and
decisions are made fully in the open, on GitHub.

Most of us use the [ASF Slack
workspace](https://s.apache.org/slack-invite) and the [Arrow Rust Discord
server][discord-link] for discussions.

There are specific channels for Arrow, DataFusion, and the DataFusion subprojects (Ballista, Comet, Python, etc).

In Slack we use these channels:

- #arrow
- #arrow-rust
- #datafusion
- #datafusion-ballista
- #datafusion-comet
- #datafusion-python

In Discord we use these channels:

- #ballista
- #comet
- #contrib-federation
- #datafusion
- #datafusion-python
- #dolomite-optimizer
- #general
- #hiring
- #incremental-materialized-views

Unfortunately, due to spammers, the ASF Slack workspace requires an invitation
to join. We are happy to invite you -- please ask for an invitation in the
Discord server.

### Job Board

There are plenty of opportunities to work with DataFusion advertised on the
#hiring channel on the [Arrow Rust Discord Server][discord-link].
Please feel free to post links to DataFusion related jobs there.

## Mailing Lists

Like other Apache projects, we use [mailing lists] for certain purposes, most
importantly release coordination. Other than the release process, most
DataFusion mailing list traffic will simply link to a GitHub issue or PR where
the actual discussion occurs. The project mailing lists are:

- [`dev@datafusion.apache.org`](mailto:dev@datafusion.apache.org): the main
  mailing list for release coordination and other project-wide discussions. Links:
  [archives](https://lists.apache.org/list.html?dev@datafusion.apache.org),
  [subscribe](mailto:dev-subscribe@datafusion.apache.org),
  [unsubscribe](mailto:dev-unsubscribe@datafusion.apache.org)
- `github@datafusion.apache.org`: read-only mailing list that receives all GitHub notifications for the project. Links:
  [archives](https://lists.apache.org/list.html?github@datafusion.apache.org)
- `commits@datafusion.apache.org`: read-only mailing list that receives all GitHub commits for the project. Links:
  [archives](https://lists.apache.org/list.html?commits@datafusion.apache.org)
- `private@datafusion.apache.org`: private mailing list for PMC members. This list has very little traffic, almost exclusively discussions on growing the committer and PMC membership. Links:
  [archives](https://lists.apache.org/list.html?private@datafusion.apache.org)

[mailing lists]: https://www.apache.org/foundation/mailinglists
[discord-link]: https://discord.gg/Qw5gKqHxUM
