/*
 * Decompiled with CFR 0.152.
 */
package org.apache.daffodil.unparsers.runtime1;

import java.math.BigDecimal;
import java.math.BigInteger;
import org.apache.daffodil.io.DataOutputStream;
import org.apache.daffodil.io.FormatInfo;
import org.apache.daffodil.lib.schema.annotation.props.gen.YesNo;
import org.apache.daffodil.lib.schema.annotation.props.gen.YesNo$No$;
import org.apache.daffodil.lib.util.Maybe$;
import org.apache.daffodil.lib.util.Maybe$One$;
import org.apache.daffodil.runtime1.processors.ElementRuntimeData;
import org.apache.daffodil.runtime1.processors.unparsers.UState;
import org.apache.daffodil.runtime1.processors.unparsers.UnparseError$;
import org.apache.daffodil.unparsers.runtime1.PackedBinaryBaseUnparser;
import scala.Int$;
import scala.Option;
import scala.collection.immutable.Seq;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;

public abstract class PackedBinaryDecimalBaseUnparser
extends PackedBinaryBaseUnparser {
    private final ElementRuntimeData e;
    private final int binaryDecimalVirtualPoint;
    private final Option<YesNo> decimalSigned;

    public PackedBinaryDecimalBaseUnparser(ElementRuntimeData e, int binaryDecimalVirtualPoint, Option<YesNo> decimalSigned) {
        this.e = e;
        this.binaryDecimalVirtualPoint = binaryDecimalVirtualPoint;
        this.decimalSigned = decimalSigned;
        super(e);
    }

    @Override
    public Number getNumberToPut(UState ustate) {
        Number number = super.getNumberToPut(ustate);
        BigDecimal bigDec = (BigDecimal)number;
        if (bigDec.movePointRight(this.binaryDecimalVirtualPoint).scale() != 0) {
            throw this.e.schemaDefinitionError("Decimal point of number '%s' does not match the binaryVirtualDecmialPoint: %d", (Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{bigDec, BoxesRunTime.boxToInteger((int)this.binaryDecimalVirtualPoint)}));
        }
        if (bigDec.signum() == -1 && this.decimalSigned.isEmpty()) {
            throw UnparseError$.MODULE$.apply(Maybe$One$.MODULE$.apply(this.e.schemaFileLocation()), Maybe$.MODULE$.Nope(), "Signed numbers with dfdl:binaryNumberRep 'bcd' are always only positive. %s cannot be negative, but value was %s", (Seq<Object>)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{this.context().dpathElementCompileInfo().namedQName().toPrettyString(), bigDec.toString()}));
        }
        if (bigDec.signum() == -1 && this.decimalSigned.isDefined()) {
            Object object = this.decimalSigned.get();
            YesNo$No$ yesNo$No$ = YesNo$No$.MODULE$;
            if (!(object != null ? !object.equals(yesNo$No$) : yesNo$No$ != null)) {
                throw UnparseError$.MODULE$.apply(Maybe$One$.MODULE$.apply(this.e.schemaFileLocation()), Maybe$.MODULE$.Nope(), "Packed binary decimal value is negative (%s), but property dfdl:decimalSigned is no", (Seq<Object>)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{bigDec.toString()}));
            }
        }
        return bigDec.unscaledValue();
    }

    @Override
    public boolean putNumber(DataOutputStream dos, Number number, int nBits, FormatInfo finfo) {
        byte[] packedNum = this.fromBigInteger((BigInteger)number, nBits);
        return dos.putByteArray(packedNum, Int$.MODULE$.int2long(packedNum.length * 8), finfo, dos.putByteArray$default$4());
    }
}

