/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.collections4.multimap;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.ListIterator;
import org.apache.commons.collections4.ListValuedMap;
import org.apache.commons.collections4.MapIterator;
import org.apache.commons.collections4.multimap.AbstractMultiValuedMapTest;
import org.apache.commons.collections4.multimap.ArrayListValuedLinkedHashMap;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class ArrayListValuedLinkedHashMapTest<K, V>
extends AbstractMultiValuedMapTest<K, V> {
    @Override
    public String getCompatibilityVersion() {
        return "4.5";
    }

    @Override
    protected int getIterationBehaviour() {
        return 1;
    }

    @Override
    public ListValuedMap<K, V> makeObject() {
        return new ArrayListValuedLinkedHashMap();
    }

    @Test
    public void testArrayListValuedLinkedHashMap() {
        HashMap<String, String> map = new HashMap<String, String>();
        HashMap map1 = new HashMap();
        map.put("A", "W");
        map.put("B", "X");
        map.put("C", "F");
        ArrayListValuedLinkedHashMap listMap = new ArrayListValuedLinkedHashMap(map);
        Assertions.assertEquals((int)1, (int)listMap.get((Object)"A").size());
        Assertions.assertEquals((int)1, (int)listMap.get((Object)"B").size());
        Assertions.assertEquals((int)1, (int)listMap.get((Object)"C").size());
        ArrayListValuedLinkedHashMap listMap1 = new ArrayListValuedLinkedHashMap(map1);
        Assertions.assertEquals((Object)"{}", (Object)listMap1.toString());
    }

    @Test
    public void testCopyConstructorWithMultiValuedMap() {
        ListValuedMap<K, V> map = this.makeObject();
        map.put((Object)"key", (Object)"sleutel");
        ArrayListValuedLinkedHashMap copy = new ArrayListValuedLinkedHashMap(map);
        Assertions.assertEquals(map, (Object)copy);
    }

    @Test
    public void testEqualsHashCodeContract() {
        ListValuedMap<K, V> map1 = this.makeObject();
        ListValuedMap<K, V> map2 = this.makeObject();
        map1.put((Object)"a", (Object)"a1");
        map1.put((Object)"a", (Object)"a2");
        map2.put((Object)"a", (Object)"a1");
        map2.put((Object)"a", (Object)"a2");
        Assertions.assertEquals(map1, map2);
        Assertions.assertEquals((int)map1.hashCode(), (int)map2.hashCode());
        map2.put((Object)"a", (Object)"a2");
        Assertions.assertNotSame(map1, map2);
        Assertions.assertNotSame((Object)map1.hashCode(), (Object)map2.hashCode());
    }

    @Test
    public void testListValuedMapAdd() {
        ListValuedMap<K, V> listMap = this.makeObject();
        Assertions.assertTrue((boolean)(listMap.get((Object)"whatever") instanceof List));
        List list = listMap.get((Object)"A");
        list.add("a1");
        Assertions.assertEquals((int)1, (int)listMap.size());
        Assertions.assertTrue((boolean)listMap.containsKey((Object)"A"));
    }

    @Test
    public void testListValuedMapAddViaListIterator() {
        ListValuedMap<K, V> listMap = this.makeObject();
        ListIterator<String> listIt = listMap.get((Object)"B").listIterator();
        Assertions.assertFalse((boolean)listIt.hasNext());
        listIt.add("b1");
        listIt.add("b2");
        listIt.add("b3");
        Assertions.assertEquals((int)3, (int)listMap.size());
        Assertions.assertTrue((boolean)listMap.containsKey((Object)"B"));
        Assertions.assertFalse((boolean)listIt.hasNext());
    }

    @Test
    public void testListValuedMapEqualsHashCodeContract() {
        ListValuedMap<K, V> map1 = this.makeObject();
        ListValuedMap<K, V> map2 = this.makeObject();
        map1.put((Object)"a", (Object)"a1");
        map1.put((Object)"a", (Object)"a2");
        map2.put((Object)"a", (Object)"a1");
        map2.put((Object)"a", (Object)"a2");
        Assertions.assertEquals(map1, map2);
        Assertions.assertEquals((int)map1.hashCode(), (int)map2.hashCode());
        map1.put((Object)"b", (Object)"b1");
        map1.put((Object)"b", (Object)"b2");
        map2.put((Object)"b", (Object)"b2");
        map2.put((Object)"b", (Object)"b1");
        Assertions.assertNotSame(map1, map2);
        Assertions.assertNotSame((Object)map1.hashCode(), (Object)map2.hashCode());
    }

    @Test
    public void testListValuedMapRemove() {
        ListValuedMap<K, V> listMap = this.makeObject();
        List list = listMap.get((Object)"A");
        list.add("a1");
        list.add("a2");
        list.add("a3");
        Assertions.assertEquals((int)3, (int)listMap.size());
        Assertions.assertEquals((Object)"a1", list.remove(0));
        Assertions.assertEquals((int)2, (int)listMap.size());
        Assertions.assertEquals((Object)"a2", list.remove(0));
        Assertions.assertEquals((int)1, (int)listMap.size());
        Assertions.assertEquals((Object)"a3", list.remove(0));
        Assertions.assertEquals((int)0, (int)listMap.size());
        Assertions.assertFalse((boolean)listMap.containsKey((Object)"A"));
    }

    @Test
    public void testListValuedMapRemoveViaListIterator() {
        ListValuedMap<K, V> listMap = this.makeObject();
        ListIterator<String> listIt = listMap.get((Object)"B").listIterator();
        listIt.add("b1");
        listIt.add("b2");
        Assertions.assertEquals((int)2, (int)listMap.size());
        Assertions.assertTrue((boolean)listMap.containsKey((Object)"B"));
        listIt = listMap.get((Object)"B").listIterator();
        while (listIt.hasNext()) {
            listIt.next();
            listIt.remove();
        }
        Assertions.assertFalse((boolean)listMap.containsKey((Object)"B"));
        listIt.add("b1");
        listIt.add("b2");
        Assertions.assertTrue((boolean)listMap.containsKey((Object)"B"));
        Assertions.assertEquals((int)2, (int)listMap.get((Object)"B").size());
    }

    @Test
    public void testPreservesKeyInsertionOrder() {
        ListValuedMap<K, V> map = this.makeObject();
        map.put((Object)5, (Object)"five");
        map.put((Object)1, (Object)"one");
        map.put((Object)5, (Object)"vijf");
        MapIterator mapIterator = map.mapIterator();
        Assertions.assertEquals((Object)5, (Object)mapIterator.next());
        Assertions.assertEquals((Object)"five", (Object)mapIterator.getValue());
        Assertions.assertEquals((Object)5, (Object)mapIterator.next());
        Assertions.assertEquals((Object)"vijf", (Object)mapIterator.getValue());
        Assertions.assertEquals((Object)1, (Object)mapIterator.next());
        Assertions.assertEquals((Object)"one", (Object)mapIterator.getValue());
        Assertions.assertFalse((boolean)mapIterator.hasNext());
    }

    @Test
    public void testTrimToSize() {
        ArrayListValuedLinkedHashMap listMap = new ArrayListValuedLinkedHashMap(4);
        Assertions.assertEquals((Object)"{}", (Object)listMap.toString());
        listMap.put((Object)"A", (Object)"W");
        listMap.put((Object)"A", (Object)"X");
        listMap.put((Object)"B", (Object)"F");
        Assertions.assertEquals((int)2, (int)listMap.get((Object)"A").size());
        Assertions.assertEquals((int)1, (int)listMap.get((Object)"B").size());
        listMap.trimToSize();
        Assertions.assertEquals((int)2, (int)listMap.get((Object)"A").size());
        Assertions.assertEquals((int)1, (int)listMap.get((Object)"B").size());
    }

    @Test
    public void testValuesListIteratorMethods() {
        ListValuedMap<K, V> listMap = this.makeObject();
        List listA = listMap.get((Object)"A");
        List<Object> list = Arrays.asList("W", "X", "F", "Q", "Q", "F");
        listA.addAll(0, list);
        ListIterator<String> it = listMap.get((Object)"A").listIterator(1);
        Assertions.assertTrue((boolean)it.hasNext());
        Assertions.assertEquals((Object)"X", it.next());
        Assertions.assertEquals((Object)"F", it.next());
        Assertions.assertTrue((boolean)it.hasPrevious());
        Assertions.assertEquals((Object)"F", it.previous());
        Assertions.assertEquals((int)2, (int)it.nextIndex());
        Assertions.assertEquals((int)1, (int)it.previousIndex());
        it.set("Z");
        Assertions.assertEquals((Object)"Z", it.next());
        Assertions.assertEquals((Object)"Q", it.next());
    }

    @Test
    public void testWrappedListAdd() {
        ListValuedMap<K, V> listMap = this.makeObject();
        List listA = listMap.get((Object)"A");
        listA.add(0, "W");
        listA.add(1, "X");
        listA.add(2, "F");
        Assertions.assertEquals((Object)"{A=[W, X, F]}", (Object)listMap.toString());
        listMap.get((Object)"A").set(1, "Q");
        Assertions.assertEquals((Object)"{A=[W, Q, F]}", (Object)listMap.toString());
    }

    @Test
    public void testWrappedListAddAll() {
        ListValuedMap<K, V> listMap = this.makeObject();
        List listA = listMap.get((Object)"A");
        List<Object> list = Arrays.asList("W", "X", "F");
        listA.addAll(0, list);
        Assertions.assertEquals((Object)"{A=[W, X, F]}", (Object)listMap.toString());
        List<Object> list1 = Arrays.asList("Q", "Q", "L");
        listA.addAll(3, list1);
        Assertions.assertEquals((Object)"{A=[W, X, F, Q, Q, L]}", (Object)listMap.toString());
        Assertions.assertEquals((Object)"W", listMap.get((Object)"A").get(0));
        Assertions.assertEquals((Object)"X", listMap.get((Object)"A").get(1));
        Assertions.assertEquals((Object)"F", listMap.get((Object)"A").get(2));
        Assertions.assertEquals((Object)"Q", listMap.get((Object)"A").get(3));
        Assertions.assertEquals((Object)"Q", listMap.get((Object)"A").get(4));
        Assertions.assertEquals((Object)"L", listMap.get((Object)"A").get(5));
        Assertions.assertEquals((int)0, (int)listMap.get((Object)"A").indexOf("W"));
        Assertions.assertEquals((int)2, (int)listMap.get((Object)"A").indexOf("F"));
        Assertions.assertEquals((int)-1, (int)listMap.get((Object)"A").indexOf("C"));
        Assertions.assertEquals((int)3, (int)listMap.get((Object)"A").indexOf("Q"));
        Assertions.assertEquals((int)4, (int)listMap.get((Object)"A").lastIndexOf("Q"));
        Assertions.assertEquals((int)-1, (int)listMap.get((Object)"A").lastIndexOf("A"));
        ArrayList list2 = new ArrayList();
        listMap.get((Object)"B").addAll(0, list2);
        Assertions.assertEquals((Object)"{A=[W, X, F, Q, Q, L]}", (Object)listMap.toString());
        List list3 = listMap.get((Object)"A").subList(1, 4);
        Assertions.assertEquals((int)3, (int)list3.size());
        Assertions.assertEquals((Object)"Q", list3.get(2));
    }
}

