/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.collections4.map;

import java.util.ArrayList;
import java.util.List;
import org.apache.commons.collections4.BulkTest;
import org.apache.commons.collections4.OrderedMapIterator;
import org.apache.commons.collections4.list.AbstractListTest;
import org.apache.commons.collections4.map.AbstractOrderedMapTest;
import org.apache.commons.collections4.map.ListOrderedMap;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class ListOrderedMap2Test<K, V>
extends AbstractOrderedMapTest<K, V> {
    public BulkTest bulkTestListView() {
        return new TestListView();
    }

    @Override
    public String getCompatibilityVersion() {
        return "4";
    }

    @Override
    public ListOrderedMap<K, V> getMap() {
        return (ListOrderedMap)super.getMap();
    }

    @Override
    public ListOrderedMap<K, V> makeFullMap() {
        return (ListOrderedMap)super.makeFullMap();
    }

    @Override
    public ListOrderedMap<K, V> makeObject() {
        return new ListOrderedMap();
    }

    @Test
    public void testGetByIndex() {
        this.resetEmpty();
        Assertions.assertThrows(IndexOutOfBoundsException.class, () -> this.getMap().get(0));
        Assertions.assertThrows(IndexOutOfBoundsException.class, () -> this.getMap().get(-1));
        this.resetFull();
        ListOrderedMap lom = this.getMap();
        Assertions.assertThrows(IndexOutOfBoundsException.class, () -> lom.get(-1));
        Assertions.assertThrows(IndexOutOfBoundsException.class, () -> lom.get(lom.size()));
        int i = 0;
        OrderedMapIterator it = lom.mapIterator();
        while (it.hasNext()) {
            Assertions.assertSame((Object)it.next(), (Object)lom.get(i));
            ++i;
        }
    }

    @Test
    public void testGetValueByIndex() {
        this.resetEmpty();
        Assertions.assertThrows(IndexOutOfBoundsException.class, () -> this.getMap().getValue(0));
        Assertions.assertThrows(IndexOutOfBoundsException.class, () -> this.getMap().getValue(-1));
        this.resetFull();
        ListOrderedMap lom = this.getMap();
        Assertions.assertThrows(IndexOutOfBoundsException.class, () -> lom.getValue(-1));
        Assertions.assertThrows(IndexOutOfBoundsException.class, () -> lom.getValue(lom.size()));
        int i = 0;
        OrderedMapIterator it = lom.mapIterator();
        while (it.hasNext()) {
            it.next();
            Assertions.assertSame((Object)it.getValue(), (Object)lom.getValue(i));
            ++i;
        }
    }

    @Test
    public void testIndexOf() {
        this.resetEmpty();
        ListOrderedMap<K, V> lom = this.getMap();
        Assertions.assertEquals((int)-1, (int)lom.indexOf(this.getOtherKeys()));
        this.resetFull();
        lom = this.getMap();
        ArrayList<Object> list = new ArrayList<Object>();
        OrderedMapIterator it = lom.mapIterator();
        while (it.hasNext()) {
            list.add(it.next());
        }
        for (int i = 0; i < list.size(); ++i) {
            Assertions.assertEquals((int)i, (int)lom.indexOf(list.get(i)));
        }
    }

    @Test
    public void testRemoveByIndex() {
        this.resetEmpty();
        Assertions.assertThrows(IndexOutOfBoundsException.class, () -> this.getMap().remove(0));
        Assertions.assertThrows(IndexOutOfBoundsException.class, () -> this.getMap().remove(-1));
        this.resetFull();
        ListOrderedMap lom = this.getMap();
        Assertions.assertThrows(IndexOutOfBoundsException.class, () -> lom.remove(-1));
        Assertions.assertThrows(IndexOutOfBoundsException.class, () -> lom.remove(lom.size()));
        ArrayList<Object> list = new ArrayList<Object>();
        OrderedMapIterator it = lom.mapIterator();
        while (it.hasNext()) {
            list.add(it.next());
        }
        for (int i = 0; i < list.size(); ++i) {
            Object key = list.get(i);
            Object value = lom.get(key);
            Assertions.assertEquals((Object)value, (Object)lom.remove(i));
            list.remove(i);
            Assertions.assertFalse((boolean)lom.containsKey(key));
        }
    }

    public class TestListView
    extends AbstractListTest<K> {
        @Override
        public K[] getFullElements() {
            return ListOrderedMap2Test.this.getSampleKeys();
        }

        @Override
        public boolean isAddSupported() {
            return false;
        }

        @Override
        public boolean isNullSupported() {
            return ListOrderedMap2Test.this.isAllowNullKey();
        }

        @Override
        public boolean isRemoveSupported() {
            return false;
        }

        @Override
        public boolean isSetSupported() {
            return false;
        }

        @Override
        public boolean isTestSerialization() {
            return false;
        }

        @Override
        public List<K> makeFullCollection() {
            return ListOrderedMap2Test.this.makeFullMap().asList();
        }

        @Override
        public List<K> makeObject() {
            return ListOrderedMap2Test.this.makeObject().asList();
        }
    }
}

