/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.collections4.collection;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import org.apache.commons.collections4.Transformer;
import org.apache.commons.collections4.collection.AbstractCollectionTest;
import org.apache.commons.collections4.collection.IndexedCollection;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class IndexedCollectionTest
extends AbstractCollectionTest<String> {
    protected Collection<String> decorateCollection(Collection<String> collection) {
        return IndexedCollection.nonUniqueIndexedCollection(collection, (Transformer)new IntegerTransformer());
    }

    protected IndexedCollection<Integer, String> decorateUniqueCollection(Collection<String> collection) {
        return IndexedCollection.uniqueIndexedCollection(collection, (Transformer)new IntegerTransformer());
    }

    public String[] getFullElements() {
        return new String[]{"1", "3", "5", "7", "2", "4", "6"};
    }

    public String[] getOtherElements() {
        return new String[]{"9", "88", "678", "87", "98", "78", "99"};
    }

    @Override
    public Collection<String> makeConfirmedCollection() {
        return new ArrayList<String>();
    }

    @Override
    public Collection<String> makeConfirmedFullCollection() {
        return new ArrayList<String>(Arrays.asList(this.getFullElements()));
    }

    @Override
    public Collection<String> makeFullCollection() {
        return this.decorateCollection(new ArrayList<String>(Arrays.asList(this.getFullElements())));
    }

    @Override
    public Collection<String> makeObject() {
        return this.decorateCollection(new ArrayList<String>());
    }

    public Collection<String> makeTestCollection() {
        return this.decorateCollection(new ArrayList<String>());
    }

    public Collection<String> makeUniqueTestCollection() {
        return this.decorateUniqueCollection(new ArrayList<String>());
    }

    @Override
    protected boolean skipSerializedCanonicalTests() {
        return true;
    }

    @Test
    public void testAddedObjectsCanBeRetrievedByKey() throws Exception {
        Collection<String> coll = this.makeTestCollection();
        coll.add("12");
        coll.add("16");
        coll.add("1");
        coll.addAll(Arrays.asList("2", "3", "4"));
        IndexedCollection indexed = (IndexedCollection)coll;
        Assertions.assertEquals((Object)"12", (Object)indexed.get((Object)12));
        Assertions.assertEquals((Object)"16", (Object)indexed.get((Object)16));
        Assertions.assertEquals((Object)"1", (Object)indexed.get((Object)1));
        Assertions.assertEquals((Object)"2", (Object)indexed.get((Object)2));
        Assertions.assertEquals((Object)"3", (Object)indexed.get((Object)3));
        Assertions.assertEquals((Object)"4", (Object)indexed.get((Object)4));
    }

    @Test
    public void testDecoratedCollectionIsIndexedOnCreation() throws Exception {
        Collection<String> original = this.makeFullCollection();
        IndexedCollection<Integer, String> indexed = this.decorateUniqueCollection(original);
        Assertions.assertEquals((Object)"1", (Object)indexed.get((Object)1));
        Assertions.assertEquals((Object)"2", (Object)indexed.get((Object)2));
        Assertions.assertEquals((Object)"3", (Object)indexed.get((Object)3));
    }

    @Test
    public void testEnsureDuplicateObjectsCauseException() throws Exception {
        Collection<String> coll = this.makeUniqueTestCollection();
        coll.add("1");
        Assertions.assertThrows(IllegalArgumentException.class, () -> coll.add("1"));
    }

    @Test
    public void testReindexUpdatesIndexWhenDecoratedCollectionIsModifiedSeparately() throws Exception {
        ArrayList<String> original = new ArrayList<String>();
        IndexedCollection<Integer, String> indexed = this.decorateUniqueCollection(original);
        original.add("1");
        original.add("2");
        original.add("3");
        Assertions.assertNull((Object)indexed.get((Object)1));
        Assertions.assertNull((Object)indexed.get((Object)2));
        Assertions.assertNull((Object)indexed.get((Object)3));
        indexed.reindex();
        Assertions.assertEquals((Object)"1", (Object)indexed.get((Object)1));
        Assertions.assertEquals((Object)"2", (Object)indexed.get((Object)2));
        Assertions.assertEquals((Object)"3", (Object)indexed.get((Object)3));
    }

    private static final class IntegerTransformer
    implements Transformer<String, Integer>,
    Serializable {
        private static final long serialVersionUID = 809439581555072949L;

        private IntegerTransformer() {
        }

        public Integer transform(String input) {
            return Integer.valueOf(input);
        }
    }
}

