/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.collections4.collection;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.lang.reflect.Array;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.ConcurrentModificationException;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Objects;
import java.util.function.Predicate;
import org.apache.commons.collections4.AbstractObjectTest;
import org.apache.commons.lang3.ArrayUtils;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public abstract class AbstractCollectionTest<E>
extends AbstractObjectTest {
    public static final int UNORDERED = 1;
    private Collection<E> collection;
    private Collection<E> confirmed;

    protected static void assertNotCollectionContains(Collection<?> coll, Object element) {
        try {
            Assertions.assertFalse((boolean)coll.contains(element));
        }
        catch (ClassCastException | NullPointerException runtimeException) {
            // empty catch block
        }
    }

    protected static void assertNotCollectionContainsAll(Collection<?> coll, Collection<?> sub) {
        try {
            Assertions.assertFalse((boolean)coll.containsAll(sub));
        }
        catch (ClassCastException | NullPointerException runtimeException) {
            // empty catch block
        }
    }

    protected static void assertNotRemoveAllFromCollection(Collection<?> coll, Collection<?> sub) {
        try {
            Assertions.assertFalse((boolean)coll.removeAll(sub));
        }
        catch (ClassCastException | NullPointerException runtimeException) {
            // empty catch block
        }
    }

    protected static void assertNotRemoveFromCollection(Collection<?> coll, Object element) {
        try {
            Assertions.assertFalse((boolean)coll.remove(element));
        }
        catch (ClassCastException | NullPointerException runtimeException) {
            // empty catch block
        }
    }

    private static void assertUnorderedArrayEquals(Object[] a1, Object[] a2, String msg) {
        Assertions.assertEquals((int)a1.length, (int)a2.length, () -> msg + ": length");
        int size = a1.length;
        boolean[] matched = new boolean[size];
        block0: for (Object o : a1) {
            for (int i = 0; i < size; ++i) {
                if (matched[i] || !Objects.equals(o, a2[i])) continue;
                matched[i] = true;
                continue block0;
            }
            Assertions.fail((String)(msg + ": array 2 does not have object: " + o));
        }
    }

    public boolean areEqualElementsDistinguishable() {
        return false;
    }

    public Map.Entry<E, E> cloneMapEntry(Map.Entry<E, E> entry) {
        HashMap<E, E> map = new HashMap<E, E>();
        map.put(entry.getKey(), entry.getValue());
        return map.entrySet().iterator().next();
    }

    public Collection<E> getCollection() {
        return this.collection;
    }

    public Collection<E> getConfirmed() {
        return this.confirmed;
    }

    public E[] getFullElements() {
        if (this.isNullSupported()) {
            ArrayList<E> list = new ArrayList<E>(Arrays.asList(this.getFullNonNullElements()));
            list.add(4, null);
            return list.toArray();
        }
        return (Object[])this.getFullNonNullElements().clone();
    }

    public E[] getFullNonNullElements() {
        return new Object[]{"", "One", 2, "Three", 4, "One", 5.0, Float.valueOf(6.0f), "Seven", "Eight", "Nine", 10, (short)11, 12L, "Thirteen", "14", "15", (byte)16};
    }

    public Object[] getFullNonNullStringElements() {
        return new Object[]{"If", "the", "dull", "substance", "of", "my", "flesh", "were", "thought", "Injurious", "distance", "could", "not", "stop", "my", "way"};
    }

    protected int getIterationBehaviour() {
        return 0;
    }

    public E[] getOtherElements() {
        return this.getOtherNonNullElements();
    }

    public E[] getOtherNonNullElements() {
        return new Object[]{0, Float.valueOf(0.0f), 0.0, "Zero", (short)0, (byte)0, 0L, Character.valueOf('\u0000'), "0"};
    }

    public Object[] getOtherNonNullStringElements() {
        return new Object[]{"For", "then", "despite", "space", "I", "would", "be", "brought", "From", "limits", "far", "remote", "where", "thou", "dost", "stay"};
    }

    public boolean isAddSupported() {
        return true;
    }

    @Override
    public boolean isEqualsCheckable() {
        return false;
    }

    public boolean isFailFastSupported() {
        return false;
    }

    public boolean isNullSupported() {
        return true;
    }

    public boolean isRemoveSupported() {
        return true;
    }

    public abstract Collection<E> makeConfirmedCollection();

    public abstract Collection<E> makeConfirmedFullCollection();

    public Collection<E> makeFullCollection() {
        Object c = this.makeObject();
        c.addAll(Arrays.asList(this.getFullElements()));
        return c;
    }

    @Override
    public abstract Collection<E> makeObject();

    public void resetEmpty() {
        this.setCollection((Collection<E>)this.makeObject());
        this.setConfirmed(this.makeConfirmedCollection());
    }

    public void resetFull() {
        this.setCollection(this.makeFullCollection());
        this.setConfirmed(this.makeConfirmedFullCollection());
    }

    public void setCollection(Collection<E> collection) {
        this.collection = collection;
    }

    public void setConfirmed(Collection<E> confirmed) {
        this.confirmed = confirmed;
    }

    @Test
    public void testCollectionAdd() {
        E[] elements;
        if (!this.isAddSupported()) {
            return;
        }
        for (E element : elements = this.getFullElements()) {
            this.resetEmpty();
            boolean r = this.getCollection().add(element);
            this.getConfirmed().add(element);
            this.verify();
            Assertions.assertTrue((boolean)r, (String)"Empty collection changed after add");
            Assertions.assertEquals((int)1, (int)this.getCollection().size(), (String)"Collection size is 1 after first add");
        }
        this.resetEmpty();
        int size = 0;
        for (E element : elements) {
            boolean r = this.getCollection().add(element);
            this.getConfirmed().add(element);
            this.verify();
            if (r) {
                ++size;
            }
            Assertions.assertEquals((int)size, (int)this.getCollection().size(), (String)"Collection size should grow after add");
            Assertions.assertTrue((boolean)this.getCollection().contains(element), (String)"Collection should contain added element");
        }
    }

    @Test
    public void testCollectionAddAll() {
        if (!this.isAddSupported()) {
            return;
        }
        this.resetEmpty();
        E[] elements = this.getFullElements();
        boolean r = this.getCollection().addAll(Arrays.asList(elements));
        this.getConfirmed().addAll(Arrays.asList(elements));
        this.verify();
        Assertions.assertTrue((boolean)r, (String)"Empty collection should change after addAll");
        for (E element : elements) {
            Assertions.assertTrue((boolean)this.getCollection().contains(element), (String)"Collection should contain added element");
        }
        this.resetFull();
        int size = this.getCollection().size();
        elements = this.getOtherElements();
        r = this.getCollection().addAll(Arrays.asList(elements));
        this.getConfirmed().addAll(Arrays.asList(elements));
        this.verify();
        Assertions.assertTrue((boolean)r, (String)"Full collection should change after addAll");
        for (E element : elements) {
            Assertions.assertTrue((boolean)this.getCollection().contains(element), (String)"Full collection should contain added element");
        }
        Assertions.assertEquals((int)(size + elements.length), (int)this.getCollection().size(), (String)"Size should increase after addAll");
        this.resetFull();
        size = this.getCollection().size();
        r = this.getCollection().addAll(Arrays.asList(this.getFullElements()));
        this.getConfirmed().addAll(Arrays.asList(this.getFullElements()));
        this.verify();
        if (r) {
            Assertions.assertTrue((size < this.getCollection().size() ? 1 : 0) != 0, (String)"Size should increase if addAll returns true");
        } else {
            Assertions.assertEquals((int)size, (int)this.getCollection().size(), (String)"Size should not change if addAll returns false");
        }
    }

    @Test
    public void testCollectionClear() {
        if (!this.isRemoveSupported()) {
            return;
        }
        this.resetEmpty();
        this.getCollection().clear();
        this.verify();
        this.resetFull();
        this.getCollection().clear();
        this.getConfirmed().clear();
        this.verify();
    }

    @Test
    public void testCollectionContains() {
        int i;
        this.resetEmpty();
        E[] elements = this.getFullElements();
        for (i = 0; i < elements.length; ++i) {
            Assertions.assertFalse((boolean)this.getCollection().contains(elements[i]), (String)("Empty collection shouldn't contain element[" + i + "]"));
        }
        this.verify();
        elements = this.getOtherElements();
        for (i = 0; i < elements.length; ++i) {
            Assertions.assertFalse((boolean)this.getCollection().contains(elements[i]), (String)("Empty collection shouldn't contain element[" + i + "]"));
        }
        this.verify();
        this.resetFull();
        elements = this.getFullElements();
        for (i = 0; i < elements.length; ++i) {
            Assertions.assertTrue((boolean)this.getCollection().contains(elements[i]), (String)("Full collection should contain element[" + i + "]"));
        }
        this.verify();
        this.resetFull();
        for (E element : elements = this.getOtherElements()) {
            Assertions.assertFalse((boolean)this.getCollection().contains(element), (String)"Full collection shouldn't contain element");
        }
    }

    @Test
    public void testCollectionContainsAll() {
        int min;
        this.resetEmpty();
        Collection<E> col = new HashSet<E>();
        Assertions.assertTrue((boolean)this.getCollection().containsAll(col), (String)"Every Collection should contain all elements of an empty Collection.");
        col.addAll(Arrays.asList(this.getOtherElements()));
        Assertions.assertFalse((boolean)this.getCollection().containsAll(col), (String)"Empty Collection shouldn't contain all elements of a non-empty Collection.");
        this.verify();
        this.resetFull();
        Assertions.assertFalse((boolean)this.getCollection().containsAll(col), (String)"Full collection shouldn't contain other elements");
        col.clear();
        col.addAll(Arrays.asList(this.getFullElements()));
        Assertions.assertTrue((boolean)this.getCollection().containsAll(col), (String)"Full collection should containAll full elements");
        this.verify();
        int n = min = this.getFullElements().length < 4 ? 0 : 2;
        int max = this.getFullElements().length == 1 ? 1 : (this.getFullElements().length <= 5 ? this.getFullElements().length - 1 : 5);
        col = Arrays.asList(this.getFullElements()).subList(min, max);
        Assertions.assertTrue((boolean)this.getCollection().containsAll(col), (String)"Full collection should containAll partial full elements");
        Assertions.assertTrue((boolean)this.getCollection().containsAll(this.getCollection()), (String)"Full collection should containAll itself");
        this.verify();
        col = new ArrayList<E>(Arrays.asList(this.getFullElements()));
        col.addAll(Arrays.asList(this.getFullElements()));
        Assertions.assertTrue((boolean)this.getCollection().containsAll(col), (String)"Full collection should containAll duplicate full elements");
        this.verify();
    }

    @Test
    public void testCollectionIsEmpty() {
        this.resetEmpty();
        Assertions.assertTrue((boolean)this.getCollection().isEmpty(), (String)"New Collection should be empty.");
        this.verify();
        this.resetFull();
        Assertions.assertFalse((boolean)this.getCollection().isEmpty(), (String)"Full collection shouldn't be empty");
        this.verify();
    }

    @Test
    public void testCollectionIterator() {
        this.resetEmpty();
        Iterator it1 = this.getCollection().iterator();
        Assertions.assertFalse((boolean)it1.hasNext(), (String)"Iterator for empty Collection shouldn't have next.");
        Iterator finalIt1 = it1;
        Assertions.assertThrows(NoSuchElementException.class, () -> finalIt1.next(), (String)"Iterator at end of Collection should throw NoSuchElementException when next is called.");
        this.verify();
        this.resetFull();
        it1 = this.getCollection().iterator();
        for (E element : this.getCollection()) {
            Assertions.assertTrue((boolean)it1.hasNext(), (String)"Iterator for full collection should haveNext");
            it1.next();
        }
        Assertions.assertFalse((boolean)it1.hasNext(), (String)"Iterator should be finished");
        ArrayList<E> list = new ArrayList<E>();
        it1 = this.getCollection().iterator();
        for (int i = 0; i < this.getCollection().size(); ++i) {
            E next = it1.next();
            Assertions.assertTrue((boolean)this.getCollection().contains(next), (String)"Collection should contain element returned by its iterator");
            list.add(next);
        }
        Iterator finalIt2 = it1;
        Assertions.assertThrows(NoSuchElementException.class, () -> finalIt2.next(), (String)"iterator.next() should raise NoSuchElementException after it finishes");
        this.verify();
    }

    @Test
    public void testCollectionIteratorFailFast() {
        if (!this.isFailFastSupported()) {
            return;
        }
        if (this.isAddSupported()) {
            this.resetFull();
            Iterator iter0 = this.getCollection().iterator();
            E o = this.getOtherElements()[0];
            this.getCollection().add(o);
            this.getConfirmed().add(o);
            Assertions.assertThrows(ConcurrentModificationException.class, () -> iter0.next(), (String)"next after add should raise ConcurrentModification");
            this.verify();
            this.resetFull();
            Iterator iter = this.getCollection().iterator();
            this.getCollection().addAll(Arrays.asList(this.getOtherElements()));
            this.getConfirmed().addAll(Arrays.asList(this.getOtherElements()));
            Assertions.assertThrows(ConcurrentModificationException.class, () -> iter.next(), (String)"next after addAll should raise ConcurrentModification");
            this.verify();
        }
        if (!this.isRemoveSupported()) {
            return;
        }
        this.resetFull();
        Iterator<E> iter = this.getCollection().iterator();
        this.getCollection().clear();
        try {
            iter.next();
            Assertions.fail((String)"next after clear should raise ConcurrentModification");
        }
        catch (ConcurrentModificationException | NoSuchElementException o) {
            // empty catch block
        }
        this.resetFull();
        Iterator iter0 = this.getCollection().iterator();
        this.getCollection().remove(this.getFullElements()[0]);
        Assertions.assertThrows(ConcurrentModificationException.class, () -> iter0.next(), (String)"next after remove should raise ConcurrentModification");
        this.resetFull();
        Iterator iter1 = this.getCollection().iterator();
        this.getCollection().removeIf(e -> false);
        Assertions.assertThrows(ConcurrentModificationException.class, () -> iter1.next(), (String)"next after removeIf should raise ConcurrentModification");
        this.resetFull();
        Iterator iter2 = this.getCollection().iterator();
        List<E> sublist = Arrays.asList(this.getFullElements()).subList(2, 5);
        this.getCollection().removeAll(sublist);
        Assertions.assertThrows(ConcurrentModificationException.class, () -> iter2.next(), (String)"next after removeAll should raise ConcurrentModification");
        this.resetFull();
        Iterator iter3 = this.getCollection().iterator();
        List<E> sublist3 = Arrays.asList(this.getFullElements()).subList(2, 5);
        this.getCollection().retainAll(sublist3);
        Assertions.assertThrows(ConcurrentModificationException.class, () -> iter3.next(), (String)"next after retainAll should raise ConcurrentModification");
    }

    @Test
    public void testCollectionIteratorRemove() {
        if (!this.isRemoveSupported()) {
            return;
        }
        this.resetEmpty();
        Assertions.assertThrows(IllegalStateException.class, () -> this.getCollection().iterator().remove(), (String)"New iterator.remove should raise IllegalState");
        this.verify();
        Iterator iter0 = this.getCollection().iterator();
        iter0.hasNext();
        Assertions.assertThrows(IllegalStateException.class, () -> iter0.remove(), (String)"New iterator.remove should raise IllegalState even after hasNext");
        this.verify();
        this.resetFull();
        int size = this.getCollection().size();
        Iterator iter = this.getCollection().iterator();
        while (iter.hasNext()) {
            Object o = iter.next();
            if (o instanceof Map.Entry) {
                o = this.cloneMapEntry((Map.Entry)o);
            }
            iter.remove();
            if (!this.areEqualElementsDistinguishable()) {
                this.getConfirmed().remove(o);
                this.verify();
            }
            Assertions.assertEquals((int)(--size), (int)this.getCollection().size(), (String)"Collection should shrink by one after iterator.remove");
        }
        Assertions.assertTrue((boolean)this.getCollection().isEmpty(), (String)"Collection should be empty after iterator purge");
        this.resetFull();
        iter = this.getCollection().iterator();
        iter.next();
        iter.remove();
        Iterator finalIter = iter;
        Assertions.assertThrows(IllegalStateException.class, () -> finalIter.remove(), (String)"Second iter.remove should raise IllegalState");
    }

    @Test
    public void testCollectionRemove() {
        E[] elements;
        if (!this.isRemoveSupported()) {
            return;
        }
        this.resetEmpty();
        for (E element : elements = this.getFullElements()) {
            Assertions.assertFalse((boolean)this.getCollection().remove(element), (String)"Shouldn't remove nonexistent element");
            this.verify();
        }
        E[] other = this.getOtherElements();
        this.resetFull();
        for (E element : other) {
            Assertions.assertFalse((boolean)this.getCollection().remove(element), (String)"Shouldn't remove nonexistent other element");
            this.verify();
        }
        int size = this.getCollection().size();
        for (E element : elements) {
            this.resetFull();
            Assertions.assertTrue((boolean)this.getCollection().remove(element), (String)("Collection should remove extant element: " + element));
            if (!this.areEqualElementsDistinguishable()) {
                this.getConfirmed().remove(element);
                this.verify();
            }
            Assertions.assertEquals((int)(size - 1), (int)this.getCollection().size(), (String)"Collection should shrink after remove");
        }
    }

    @Test
    public void testCollectionRemoveAll() {
        int min;
        if (!this.isRemoveSupported()) {
            return;
        }
        this.resetEmpty();
        Assertions.assertFalse((boolean)this.getCollection().removeAll(Collections.EMPTY_SET), (String)"Empty collection removeAll should return false for empty input");
        this.verify();
        Assertions.assertFalse((boolean)this.getCollection().removeAll(new ArrayList<E>(this.getCollection())), (String)"Empty collection removeAll should return false for nonempty input");
        this.verify();
        this.resetFull();
        Assertions.assertFalse((boolean)this.getCollection().removeAll(Collections.EMPTY_SET), (String)"Full collection removeAll should return false for empty input");
        this.verify();
        Assertions.assertFalse((boolean)this.getCollection().removeAll(Arrays.asList(this.getOtherElements())), (String)"Full collection removeAll should return false for other elements");
        this.verify();
        Assertions.assertTrue((boolean)this.getCollection().removeAll(new HashSet<E>(this.getCollection())), (String)"Full collection removeAll should return true for full elements");
        this.getConfirmed().removeAll(new HashSet<E>(this.getConfirmed()));
        this.verify();
        this.resetFull();
        int size = this.getCollection().size();
        int n = min = this.getFullElements().length < 4 ? 0 : 2;
        int max = this.getFullElements().length == 1 ? 1 : (this.getFullElements().length <= 5 ? this.getFullElements().length - 1 : 5);
        List<E> all = Arrays.asList(this.getFullElements()).subList(min, max);
        Assertions.assertTrue((boolean)this.getCollection().removeAll(all), (String)"Full collection removeAll should work");
        this.getConfirmed().removeAll(all);
        this.verify();
        Assertions.assertTrue((this.getCollection().size() < size ? 1 : 0) != 0, (String)"Collection should shrink after removeAll");
        for (Object element : all) {
            Assertions.assertFalse((boolean)this.getCollection().contains(element), (String)"Collection shouldn't contain removed element");
        }
    }

    @Test
    public void testCollectionRemoveIf() {
        if (!this.isRemoveSupported()) {
            return;
        }
        this.resetEmpty();
        Assertions.assertFalse((boolean)this.getCollection().removeIf(e -> false), (String)"Empty collection removeIf should return false for a predicate that returns only false");
        this.verify();
        Assertions.assertFalse((boolean)this.getCollection().removeIf(e -> true), (String)"Empty collection removeIf should return false for a predicate that returns only true");
        this.verify();
        this.resetFull();
        Assertions.assertFalse((boolean)this.getCollection().removeIf(e -> false), (String)"Full collection removeIf should return false for a predicate that returns only false");
        this.verify();
        Assertions.assertTrue((boolean)this.getCollection().removeIf(e -> true), (String)"Full collection removeIf should return true for a predicate that returns only true");
        this.getConfirmed().removeIf(e -> true);
        this.verify();
        this.resetFull();
        List<E> elements = Arrays.asList(this.getFullElements());
        int mid = this.getFullElements().length / 2;
        E target = elements.get(mid);
        int size = this.getCollection().size();
        int targetCount = Collections.frequency(elements, target);
        Predicate<Object> filter = target::equals;
        Assertions.assertTrue((boolean)this.getCollection().removeIf(filter), (String)"Full collection removeIf should work");
        this.getConfirmed().removeIf(filter);
        this.verify();
        Assertions.assertEquals((int)this.getCollection().size(), (int)(size - targetCount), (String)"Collection should shrink after removeIf");
        Assertions.assertFalse((boolean)this.getCollection().contains(target), (String)"Collection shouldn't contain removed element");
    }

    @Test
    public void testCollectionRetainAll() {
        if (!this.isRemoveSupported()) {
            return;
        }
        this.resetEmpty();
        List<E> elements = Arrays.asList(this.getFullElements());
        List<E> other = Arrays.asList(this.getOtherElements());
        Assertions.assertFalse((boolean)this.getCollection().retainAll(Collections.EMPTY_SET), (String)"Empty retainAll() should return false");
        this.verify();
        Assertions.assertFalse((boolean)this.getCollection().retainAll(elements), (String)"Empty retainAll() should return false");
        this.verify();
        this.resetFull();
        Assertions.assertTrue((boolean)this.getCollection().retainAll(Collections.EMPTY_SET), (String)"Collection should change from retainAll empty");
        this.getConfirmed().retainAll(Collections.EMPTY_SET);
        this.verify();
        this.resetFull();
        Assertions.assertTrue((boolean)this.getCollection().retainAll(other), (String)"Collection changed from retainAll other");
        this.getConfirmed().retainAll(other);
        this.verify();
        this.resetFull();
        int size = this.getCollection().size();
        Assertions.assertFalse((boolean)this.getCollection().retainAll(elements), (String)"Collection shouldn't change from retainAll elements");
        this.verify();
        Assertions.assertEquals((int)size, (int)this.getCollection().size(), (String)"Collection size shouldn't change");
        if (this.getFullElements().length > 1) {
            this.resetFull();
            size = this.getCollection().size();
            int min = this.getFullElements().length < 4 ? 0 : 2;
            int max = this.getFullElements().length <= 5 ? this.getFullElements().length - 1 : 5;
            Assertions.assertTrue((boolean)this.getCollection().retainAll(elements.subList(min, max)), (String)"Collection should changed by partial retainAll");
            this.getConfirmed().retainAll(elements.subList(min, max));
            this.verify();
            for (E element : this.getCollection()) {
                Assertions.assertTrue((boolean)elements.subList(min, max).contains(element), (String)"Collection only contains retained element");
            }
        }
        this.resetFull();
        HashSet<E> set = new HashSet<E>(elements);
        size = this.getCollection().size();
        Assertions.assertFalse((boolean)this.getCollection().retainAll(set), (String)"Collection shouldn't change from retainAll without duplicate elements");
        this.verify();
        Assertions.assertEquals((int)size, (int)this.getCollection().size(), (String)"Collection size didn't change from nonduplicate retainAll");
    }

    @Test
    public void testCollectionSize() {
        this.resetEmpty();
        Assertions.assertEquals((int)0, (int)this.getCollection().size(), (String)"Size of new Collection is 0.");
        this.resetFull();
        Assertions.assertFalse((boolean)this.getCollection().isEmpty(), (String)"Size of full collection should be greater than zero");
    }

    @Test
    public void testCollectionToArray() {
        this.resetEmpty();
        Assertions.assertEquals((int)0, (int)this.getCollection().toArray().length, (String)"Empty Collection should return empty array for toArray");
        this.resetFull();
        Object[] array = this.getCollection().toArray();
        Assertions.assertEquals((int)array.length, (int)this.getCollection().size(), (String)"Full collection toArray should be same size as collection");
        Object[] confirmedArray = this.getConfirmed().toArray();
        Assertions.assertEquals((int)confirmedArray.length, (int)array.length, (String)"length of array from confirmed collection should match the length of the collection's array");
        boolean[] matched = new boolean[array.length];
        for (int i = 0; i < array.length; ++i) {
            Assertions.assertTrue((boolean)this.getCollection().contains(array[i]), (String)"Collection should contain element in toArray");
            boolean match = false;
            for (int j = 0; j < array.length; ++j) {
                if (matched[j] || !Objects.equals(array[i], confirmedArray[j])) continue;
                matched[j] = true;
                match = true;
                break;
            }
            if (match) continue;
            Assertions.fail((String)("element " + i + " in returned array should be found in the confirmed collection's array"));
        }
        for (boolean element : matched) {
            Assertions.assertTrue((boolean)element, (String)"Collection should return all its elements in toArray");
        }
    }

    @Test
    public void testCollectionToArray2() {
        this.resetEmpty();
        Object[] a = new Object[]{new Object(), null, null};
        Object[] array = this.getCollection().toArray(a);
        Assertions.assertEquals((Object)array, (Object)a, (String)"Given array shouldn't shrink");
        Assertions.assertNull((Object)a[0], (String)"Last element should be set to null");
        this.verify();
        this.resetFull();
        Assertions.assertThrows(ArrayStoreException.class, () -> this.getCollection().toArray(new Void[0]), (String)"toArray(new Void[0]) should raise ArrayStore");
        this.verify();
        Assertions.assertThrows(NullPointerException.class, () -> this.getCollection().toArray((Object[])null), (String)"toArray(null) should raise NPE");
        this.verify();
        array = this.getCollection().toArray(ArrayUtils.EMPTY_OBJECT_ARRAY);
        a = this.getCollection().toArray();
        if ((this.getIterationBehaviour() & 1) != 0) {
            AbstractCollectionTest.assertUnorderedArrayEquals(array, a, "toArray(Object[]) and toArray()");
        } else {
            Assertions.assertEquals(Arrays.asList(array), Arrays.asList(a), (String)"toArrays should be equal");
        }
        HashSet classes = new HashSet();
        for (Object element : array) {
            classes.add(element == null ? null : element.getClass());
        }
        if (classes.size() > 1) {
            return;
        }
        Class<Map.Entry> cl = (Class<Map.Entry>)classes.iterator().next();
        if (Map.Entry.class.isAssignableFrom(cl)) {
            cl = Map.Entry.class;
        }
        a = (Object[])Array.newInstance(cl, 0);
        array = this.getCollection().toArray(a);
        Assertions.assertEquals(a.getClass(), array.getClass(), (String)"toArray(Object[]) should return correct array type");
        if ((this.getIterationBehaviour() & 1) != 0) {
            AbstractCollectionTest.assertUnorderedArrayEquals(array, this.getCollection().toArray(), "type-specific toArray(T[]) and toArray()");
        } else {
            Assertions.assertEquals(Arrays.asList(array), Arrays.asList(this.getCollection().toArray()), (String)"type-specific toArrays should be equal");
        }
        this.verify();
    }

    @Test
    public void testCollectionToString() {
        this.resetEmpty();
        Assertions.assertNotNull((Object)this.getCollection().toString(), (String)"toString shouldn't return null");
        this.resetFull();
        Assertions.assertNotNull((Object)this.getCollection().toString(), (String)"toString shouldn't return null");
    }

    @Override
    @Test
    public void testSerializeDeserializeThenCompare() throws Exception {
        Object dest;
        ObjectInputStream in;
        ObjectOutputStream out;
        ByteArrayOutputStream buffer;
        Collection<E> obj = this.makeObject();
        if (obj instanceof Serializable && this.isTestSerialization()) {
            buffer = new ByteArrayOutputStream();
            out = new ObjectOutputStream(buffer);
            out.writeObject(obj);
            out.close();
            in = new ObjectInputStream(new ByteArrayInputStream(buffer.toByteArray()));
            dest = in.readObject();
            in.close();
            if (this.isEqualsCheckable()) {
                Assertions.assertEquals(obj, (Object)dest, (String)"obj != deserialize(serialize(obj)) - EMPTY Collection");
            }
        }
        if ((obj = this.makeFullCollection()) instanceof Serializable && this.isTestSerialization()) {
            buffer = new ByteArrayOutputStream();
            out = new ObjectOutputStream(buffer);
            out.writeObject(obj);
            out.close();
            in = new ObjectInputStream(new ByteArrayInputStream(buffer.toByteArray()));
            dest = in.readObject();
            in.close();
            if (this.isEqualsCheckable()) {
                Assertions.assertEquals(obj, (Object)dest, (String)"obj != deserialize(serialize(obj)) - FULL Collection");
            }
        }
    }

    @Test
    public void testUnsupportedAdd() {
        if (this.isAddSupported()) {
            return;
        }
        this.resetEmpty();
        Assertions.assertThrows(UnsupportedOperationException.class, () -> this.getCollection().add(this.getFullNonNullElements()[0]), (String)"Empty collection should not support add.");
        this.verify();
        Assertions.assertThrows(UnsupportedOperationException.class, () -> this.getCollection().addAll(Arrays.asList(this.getFullElements())), (String)"Empty collection should not support addAll.");
        this.verify();
        this.resetFull();
        Assertions.assertThrows(UnsupportedOperationException.class, () -> this.getCollection().add(this.getFullNonNullElements()[0]), (String)"Full collection should not support add.");
        this.verify();
        Assertions.assertThrows(UnsupportedOperationException.class, () -> this.getCollection().addAll(Arrays.asList(this.getOtherElements())), (String)"Full collection should not support addAll.");
        this.verify();
    }

    @Test
    public void testUnsupportedRemove() {
        if (this.isRemoveSupported()) {
            return;
        }
        this.resetEmpty();
        Assertions.assertThrows(UnsupportedOperationException.class, () -> this.getCollection().clear(), (String)"clear should raise UnsupportedOperationException");
        this.verify();
        Assertions.assertThrows(UnsupportedOperationException.class, () -> this.getCollection().remove(null), (String)"remove should raise UnsupportedOperationException");
        this.verify();
        Assertions.assertThrows(UnsupportedOperationException.class, () -> this.getCollection().removeIf(e -> true), (String)"removeIf should raise UnsupportedOperationException");
        this.verify();
        Assertions.assertThrows(UnsupportedOperationException.class, () -> this.getCollection().removeAll(null), (String)"removeAll should raise UnsupportedOperationException");
        this.verify();
        Assertions.assertThrows(UnsupportedOperationException.class, () -> this.getCollection().retainAll(null), (String)"retainAll should raise UnsupportedOperationException");
        this.verify();
        this.resetFull();
        Iterator iterator = this.getCollection().iterator();
        iterator.next();
        Assertions.assertThrows(UnsupportedOperationException.class, () -> iterator.remove(), (String)"iterator.remove should raise UnsupportedOperationException");
        this.verify();
    }

    public void verify() {
        int confirmedSize = this.getConfirmed().size();
        Assertions.assertEquals((int)confirmedSize, (int)this.getCollection().size(), (String)"Collection size should match confirmed collection's");
        Assertions.assertEquals((Object)this.getConfirmed().isEmpty(), (Object)this.getCollection().isEmpty(), (String)"Collection isEmpty() result should match confirmed collection's");
        Object[] confirmedValues = new Object[confirmedSize];
        Iterator<E> iter = this.getConfirmed().iterator();
        int pos = 0;
        while (iter.hasNext()) {
            confirmedValues[pos++] = iter.next();
        }
        boolean[] matched = new boolean[confirmedSize];
        for (E o : this.getCollection()) {
            boolean match = false;
            for (int i = 0; i < confirmedSize; ++i) {
                if (matched[i] || !Objects.equals(o, confirmedValues[i])) continue;
                matched[i] = true;
                match = true;
                break;
            }
            if (match) continue;
            Assertions.fail((String)("Collection should not contain a value that the confirmed collection does not have: " + o + "\nTest: " + this.getCollection() + "\nReal: " + this.getConfirmed()));
        }
        for (int i = 0; i < confirmedSize; ++i) {
            if (matched[i]) continue;
            Assertions.fail((String)("Collection should contain all values that are in the confirmed collection\nTest: " + this.getCollection() + "\nReal: " + this.getConfirmed()));
        }
    }
}

