/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.collections4.bloomfilter;

import java.util.ArrayList;
import java.util.BitSet;
import java.util.SplittableRandom;
import java.util.concurrent.ThreadLocalRandom;
import java.util.function.IntPredicate;
import org.apache.commons.collections4.bloomfilter.IndexFilter;
import org.apache.commons.collections4.bloomfilter.Shape;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.params.ParameterizedTest;
import org.junit.jupiter.params.provider.CsvSource;

public class IndexFilterTest {
    @ParameterizedTest
    @CsvSource(value={"1, 64", "2, 64", "3, 64", "7, 357", "7, 17"})
    void testFilter(int k, int m) {
        Shape shape = Shape.fromKM((int)k, (int)m);
        BitSet used = new BitSet(m);
        for (int n = 0; n < 10; ++n) {
            used.clear();
            ArrayList consumer = new ArrayList();
            IntPredicate filter = IndexFilter.create((Shape)shape, consumer::add);
            long seed = ThreadLocalRandom.current().nextLong();
            SplittableRandom rng = new SplittableRandom(seed);
            int i2 = Math.min(k, m / 2);
            while (i2-- > 0) {
                int bit2 = rng.nextInt(m);
                int newSize = consumer.size() + (used.get(bit2) ? 0 : 1);
                Assertions.assertTrue((boolean)filter.test(bit2));
                Assertions.assertEquals((int)newSize, (int)consumer.size(), () -> String.format("Bad filter. Seed=%d, bit=%d", seed, bit2));
                used.set(bit2);
            }
            Assertions.assertArrayEquals((int[])used.stream().toArray(), (int[])consumer.stream().mapToInt(i -> i).sorted().toArray());
            int size = consumer.size();
            used.stream().forEach(bit -> {
                Assertions.assertTrue((boolean)filter.test(bit));
                Assertions.assertEquals((int)size, (int)consumer.size(), () -> String.format("Bad filter. Seed=%d, bit=%d", seed, bit));
            });
            Assertions.assertThrows(IndexOutOfBoundsException.class, () -> filter.test(m));
            Assertions.assertThrows(IndexOutOfBoundsException.class, () -> filter.test(-1));
        }
    }

    @Test
    public void testFiltering() {
        int i;
        Shape shape = Shape.fromKM((int)3, (int)12);
        ArrayList consumer = new ArrayList();
        IntPredicate filter = IndexFilter.create((Shape)shape, consumer::add);
        for (i = 0; i < 12; ++i) {
            Assertions.assertTrue((boolean)filter.test(i));
        }
        Assertions.assertEquals((int)12, (int)consumer.size());
        for (i = 0; i < 12; ++i) {
            Assertions.assertTrue((boolean)filter.test(i));
        }
        Assertions.assertEquals((int)12, (int)consumer.size());
    }
}

