/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.collections4.bloomfilter;

import java.util.ArrayList;
import java.util.List;
import java.util.function.BiPredicate;
import org.apache.commons.collections4.bloomfilter.CountingPredicate;
import org.apache.commons.lang3.tuple.Pair;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class CountingPredicateTest {
    private final Integer[] ary = new Integer[]{1, 2};

    private BiPredicate<Integer, Integer> makeFunc(BiPredicate<Integer, Integer> inner, List<Pair<Integer, Integer>> result) {
        return (x, y) -> {
            if (inner.test((Integer)x, (Integer)y)) {
                result.add(Pair.of((Object)x, (Object)y));
                return true;
            }
            return false;
        };
    }

    @Test
    public void testPredicateLonger() {
        ArrayList<Pair> expected = new ArrayList<Pair>();
        ArrayList<Pair<Integer, Integer>> result = new ArrayList<Pair<Integer, Integer>>();
        expected.add(Pair.of((Object)1, (Object)3));
        CountingPredicate cp = new CountingPredicate((Object[])this.ary, this.makeFunc((x, y) -> x != null, result));
        Assertions.assertTrue((boolean)cp.test((Object)3));
        Assertions.assertEquals(expected, result);
        expected.add(Pair.of((Object)2, null));
        Assertions.assertTrue((boolean)cp.processRemaining());
        Assertions.assertEquals(expected, result);
        expected.clear();
        expected.add(Pair.of((Object)1, null));
        expected.add(Pair.of((Object)2, null));
        result.clear();
        cp = new CountingPredicate((Object[])this.ary, this.makeFunc((x, y) -> x != null, result));
        Assertions.assertTrue((boolean)cp.processRemaining());
        Assertions.assertEquals(expected, result);
        expected.clear();
        expected.add(Pair.of((Object)1, null));
        result.clear();
        cp = new CountingPredicate((Object[])this.ary, this.makeFunc((x, y) -> x == Integer.valueOf(1), result));
        Assertions.assertFalse((boolean)cp.processRemaining());
        Assertions.assertEquals(expected, result);
    }

    @Test
    public void testPredicateSameLength() {
        ArrayList<Pair> expected = new ArrayList<Pair>();
        ArrayList<Pair<Integer, Integer>> result = new ArrayList<Pair<Integer, Integer>>();
        expected.add(Pair.of((Object)1, (Object)3));
        expected.add(Pair.of((Object)2, (Object)3));
        CountingPredicate cp = new CountingPredicate((Object[])this.ary, this.makeFunc((x, y) -> true, result));
        Assertions.assertTrue((boolean)cp.test((Object)3));
        Assertions.assertTrue((boolean)cp.test((Object)3));
        Assertions.assertEquals(expected, result);
        Assertions.assertTrue((boolean)cp.processRemaining());
        Assertions.assertEquals(expected, result);
    }

    @Test
    public void testPredicateShorter() {
        ArrayList<Pair> expected = new ArrayList<Pair>();
        ArrayList<Pair<Integer, Integer>> result = new ArrayList<Pair<Integer, Integer>>();
        Object[] shortAry = new Integer[]{3};
        expected.add(Pair.of((Object)3, (Object)1));
        expected.add(Pair.of(null, (Object)2));
        CountingPredicate cp = new CountingPredicate(shortAry, this.makeFunc((x, y) -> true, result));
        for (Integer i : this.ary) {
            Assertions.assertTrue((boolean)cp.test((Object)i));
        }
        Assertions.assertEquals(expected, result);
        Assertions.assertTrue((boolean)cp.processRemaining());
        Assertions.assertEquals(expected, result);
    }
}

