/*
 * Decompiled with CFR 0.152.
 */
package o.a.c.sidecar.client.shaded.io.vertx.core.impl;

import java.util.concurrent.CountDownLatch;
import java.util.concurrent.Executor;
import o.a.c.sidecar.client.shaded.io.vertx.core.Vertx;
import o.a.c.sidecar.client.shaded.io.vertx.core.impl.ContextInternal;
import o.a.c.sidecar.client.shaded.io.vertx.core.impl.EventExecutor;
import o.a.c.sidecar.client.shaded.io.vertx.core.impl.TaskQueue;
import o.a.c.sidecar.client.shaded.io.vertx.core.impl.WorkerPool;
import o.a.c.sidecar.client.shaded.io.vertx.core.spi.metrics.PoolMetrics;

public class WorkerExecutor
implements EventExecutor {
    private final WorkerPool workerPool;
    private final TaskQueue orderedTasks;
    private final ThreadLocal<Boolean> inThread = new ThreadLocal();

    public static WorkerExecutor unwrapWorkerExecutor() {
        ContextInternal ctx = (ContextInternal)Vertx.currentContext();
        if (ctx != null) {
            Executor executor = (ctx = ctx.unwrap()).executor();
            if (executor instanceof WorkerExecutor) {
                return (WorkerExecutor)executor;
            }
            throw new IllegalStateException("Cannot be called on a Vert.x event-loop thread");
        }
        throw new IllegalStateException("Not running from a Vert.x virtual thread");
    }

    public WorkerExecutor(WorkerPool workerPool, TaskQueue orderedTasks) {
        this.workerPool = workerPool;
        this.orderedTasks = orderedTasks;
    }

    @Override
    public boolean inThread() {
        return this.inThread.get() == Boolean.TRUE;
    }

    @Override
    public void execute(Runnable command) {
        PoolMetrics metrics = this.workerPool.metrics();
        Object queueMetric = metrics != null ? metrics.submitted() : null;
        this.orderedTasks.execute(() -> {
            Object execMetric = null;
            if (metrics != null) {
                execMetric = metrics.begin(queueMetric);
            }
            try {
                this.inThread.set(true);
                try {
                    command.run();
                }
                finally {
                    this.inThread.remove();
                }
            }
            finally {
                if (metrics != null) {
                    metrics.end(execMetric, true);
                }
            }
        }, this.workerPool.executor());
    }

    public TaskController current() {
        return this.orderedTasks.current();
    }

    public static interface TaskController {
        public void resume(Runnable var1);

        default public void resume() {
            this.resume(() -> {});
        }

        default public void suspendAndAwaitResume() throws InterruptedException {
            this.suspend().await();
        }

        public CountDownLatch suspend();
    }
}

