/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.tools.nodetool;

import com.google.common.collect.LinkedHashMultimap;
import io.airlift.airline.Arguments;
import io.airlift.airline.Command;
import io.airlift.airline.Option;
import java.io.PrintStream;
import java.net.UnknownHostException;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Map;
import org.apache.cassandra.locator.EndpointSnitchInfoMBean;
import org.apache.cassandra.tools.NodeProbe;
import org.apache.cassandra.tools.NodeTool;
import org.apache.cassandra.tools.nodetool.HostStatWithPort;
import org.apache.cassandra.tools.nodetool.SetHostStatWithPort;

@Command(name="ring", description="Print information about the token ring")
public class Ring
extends NodeTool.NodeToolCmd {
    @Arguments(description="Specify a keyspace for accurate ownership information (topology awareness)")
    private String keyspace = null;
    @Option(title="resolve_ip", name={"-r", "--resolve-ip"}, description="Show node domain names instead of IPs")
    private boolean resolveIp = false;
    private PrintStream out;
    private EndpointSnitchInfoMBean epSnitchInfo;
    private Collection<String> liveNodes;
    private Collection<String> deadNodes;
    private Collection<String> joiningNodes;
    private Collection<String> leavingNodes;
    private Collection<String> movingNodes;
    private Map<String, String> loadMap;

    @Override
    public void execute(NodeProbe probe) {
        this.out = probe.output().out;
        this.liveNodes = probe.getLiveNodes(true);
        this.deadNodes = probe.getUnreachableNodes(true);
        this.joiningNodes = probe.getJoiningNodes(true);
        this.leavingNodes = probe.getLeavingNodes(true);
        this.movingNodes = probe.getMovingNodes(true);
        this.loadMap = probe.getLoadMap(true);
        this.epSnitchInfo = probe.getEndpointSnitchInfoProxy();
        Map<String, String> tokensToEndpoints = probe.getTokenToEndpointMap(true);
        LinkedHashMultimap<String, String> endpointsToTokens = LinkedHashMultimap.create();
        boolean haveVnodes = false;
        for (Map.Entry<String, String> entry : tokensToEndpoints.entrySet()) {
            haveVnodes |= endpointsToTokens.containsKey(entry.getValue());
            endpointsToTokens.put((Object)entry.getValue(), (Object)entry.getKey());
        }
        int maxAddressLength = Collections.max(endpointsToTokens.keys(), Comparator.comparingInt(String::length)).length();
        String formatPlaceholder = "%%-%ds  %%-12s%%-7s%%-8s%%-16s%%-20s%%-44s%%n";
        String format = String.format(formatPlaceholder, maxAddressLength);
        StringBuilder errors = new StringBuilder();
        boolean showEffectiveOwnership = true;
        Map<String, Float> ownerships = null;
        try {
            ownerships = probe.effectiveOwnershipWithPort(this.keyspace);
        }
        catch (IllegalStateException ex) {
            try {
                ownerships = probe.getOwnershipWithPort();
                errors.append("Note: ").append(ex.getMessage()).append("%n");
                showEffectiveOwnership = false;
            }
            catch (Exception e) {
                this.out.printf("%nError: %s%n", ex.getMessage());
                System.exit(1);
            }
        }
        catch (IllegalArgumentException ex) {
            this.out.printf("%nError: %s%n", ex.getMessage());
            System.exit(1);
        }
        this.out.println();
        for (Map.Entry<String, SetHostStatWithPort> entry : NodeTool.getOwnershipByDcWithPort(probe, this.resolveIp, tokensToEndpoints, ownerships).entrySet()) {
            this.printDc(format, entry.getKey(), endpointsToTokens, entry.getValue(), showEffectiveOwnership);
        }
        if (haveVnodes) {
            this.out.println("  Warning: \"nodetool ring\" is used to output all the tokens of a node.");
            this.out.println("  To view status related info of a node use \"nodetool status\" instead.\n");
        }
        this.out.printf("%n  " + errors, new Object[0]);
    }

    private void printDc(String format, String dc, LinkedHashMultimap<String, String> endpointsToTokens, SetHostStatWithPort hoststats, boolean showEffectiveOwnership) {
        this.out.println("Datacenter: " + dc);
        this.out.println("==========");
        ArrayList tokens = new ArrayList();
        String lastToken = "";
        for (HostStatWithPort stat : hoststats) {
            tokens.addAll(endpointsToTokens.get((Object)stat.endpointWithPort.getHostAddressAndPort()));
            lastToken = (String)tokens.get(tokens.size() - 1);
        }
        this.out.printf(format, "Address", "Rack", "Status", "State", "Load", "Owns", "Token");
        if (hoststats.size() > 1) {
            this.out.printf(format, "", "", "", "", "", "", lastToken);
        } else {
            this.out.println();
        }
        for (HostStatWithPort stat : hoststats) {
            String rack;
            String endpoint = stat.endpointWithPort.getHostAddressAndPort();
            try {
                rack = this.epSnitchInfo.getRack(endpoint);
            }
            catch (UnknownHostException e) {
                rack = "Unknown";
            }
            String status = this.liveNodes.contains(endpoint) ? "Up" : (this.deadNodes.contains(endpoint) ? "Down" : "?");
            String state = "Normal";
            if (this.joiningNodes.contains(endpoint)) {
                state = "Joining";
            } else if (this.leavingNodes.contains(endpoint)) {
                state = "Leaving";
            } else if (this.movingNodes.contains(endpoint)) {
                state = "Moving";
            }
            String load = this.loadMap.getOrDefault(endpoint, "?");
            String owns = stat.owns != null && showEffectiveOwnership ? new DecimalFormat("##0.00%").format(stat.owns) : "?";
            this.out.printf(format, stat.ipOrDns(this.printPort), rack, status, state, load, owns, stat.token);
        }
        this.out.println();
    }
}

