/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.io.util;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import io.netty.util.concurrent.FastThreadLocal;
import java.io.IOException;
import java.nio.BufferOverflowException;
import java.nio.ByteBuffer;
import java.nio.channels.WritableByteChannel;
import java.nio.charset.CharacterCodingException;
import java.nio.charset.StandardCharsets;
import org.apache.cassandra.config.CassandraRelevantProperties;
import org.apache.cassandra.io.util.BufferedDataOutputStreamPlus;
import org.apache.cassandra.io.util.FileUtils;
import org.apache.cassandra.utils.ByteBufferUtil;

public class DataOutputBuffer
extends BufferedDataOutputStreamPlus {
    static final long DOUBLING_THRESHOLD = CassandraRelevantProperties.DOB_DOUBLING_THRESHOLD_MB.getLong();
    private static final int MAX_RECYCLE_BUFFER_SIZE = CassandraRelevantProperties.DOB_MAX_RECYCLE_BYTES.getInt();
    private static final AllocationType ALLOCATION_TYPE = CassandraRelevantProperties.DATA_OUTPUT_BUFFER_ALLOCATE_TYPE.getEnum(AllocationType.DIRECT);
    private static final int DEFAULT_INITIAL_BUFFER_SIZE = 128;
    public static final FastThreadLocal<DataOutputBuffer> scratchBuffer = new FastThreadLocal<DataOutputBuffer>(){

        @Override
        protected DataOutputBuffer initialValue() {
            return new DataOutputBuffer(){

                @Override
                public void close() {
                    if (this.buffer != null && this.buffer.capacity() <= MAX_RECYCLE_BUFFER_SIZE) {
                        this.buffer.clear();
                    } else {
                        this.setBuffer(this.allocate(128));
                    }
                }

                @Override
                protected ByteBuffer allocate(int size) {
                    return ALLOCATION_TYPE == AllocationType.DIRECT ? ByteBuffer.allocateDirect(size) : ByteBuffer.allocate(size);
                }
            };
        }
    };
    @VisibleForTesting
    static final int MAX_ARRAY_SIZE = 0x7FFFFFF7;

    public DataOutputBuffer() {
        super(128);
    }

    public DataOutputBuffer(int size) {
        super(size);
    }

    public DataOutputBuffer(ByteBuffer buffer) {
        super(buffer);
    }

    @Override
    public void flush() {
    }

    @VisibleForTesting
    static int saturatedArraySizeCast(long size) {
        Preconditions.checkArgument(size >= 0L);
        return (int)Math.min(0x7FFFFFF7L, size);
    }

    @VisibleForTesting
    static int checkedArraySizeCast(long size) {
        Preconditions.checkArgument(size >= 0L);
        Preconditions.checkArgument(size <= 0x7FFFFFF7L);
        return (int)size;
    }

    @Override
    protected void doFlush(int count) throws IOException {
        this.expandToFit(count);
    }

    @VisibleForTesting
    long capacity() {
        return this.buffer.capacity();
    }

    @VisibleForTesting
    long validateReallocation(long newSize) {
        int saturatedSize = DataOutputBuffer.saturatedArraySizeCast(newSize);
        if ((long)saturatedSize <= this.capacity()) {
            throw new BufferOverflowException();
        }
        return saturatedSize;
    }

    @VisibleForTesting
    long calculateNewSize(long count) {
        long capacity = this.capacity();
        long newSize = capacity + count;
        newSize = capacity > 0x100000L * DOUBLING_THRESHOLD ? Math.max(capacity * 3L / 2L, newSize) : Math.max(capacity * 2L, newSize);
        return this.validateReallocation(newSize);
    }

    protected void expandToFit(long count) {
        if (count <= 0L) {
            return;
        }
        ByteBuffer newBuffer = this.allocate(DataOutputBuffer.checkedArraySizeCast(this.calculateNewSize(count)));
        this.buffer.flip();
        newBuffer.put(this.buffer);
        this.setBuffer(newBuffer);
    }

    protected void setBuffer(ByteBuffer newBuffer) {
        FileUtils.clean(this.buffer);
        this.buffer = newBuffer;
    }

    @Override
    protected WritableByteChannel newDefaultChannel() {
        return new GrowingChannel();
    }

    public void clear() {
        this.buffer.clear();
    }

    @Override
    public void close() {
    }

    public ByteBuffer buffer() {
        return this.buffer(true);
    }

    public ByteBuffer buffer(boolean duplicate) {
        if (!duplicate) {
            ByteBuffer buf = this.buffer;
            buf.flip();
            this.buffer = null;
            return buf;
        }
        ByteBuffer result = this.buffer.duplicate();
        result.flip();
        return result;
    }

    public ByteBuffer unsafeGetBufferAndFlip() {
        this.buffer.flip();
        return this.buffer;
    }

    public byte[] getData() {
        assert (this.buffer.arrayOffset() == 0);
        return this.buffer.array();
    }

    public int getLength() {
        return this.buffer.position();
    }

    @Override
    public boolean hasPosition() {
        return true;
    }

    @Override
    public long position() {
        return this.getLength();
    }

    public ByteBuffer asNewBuffer() {
        return ByteBuffer.wrap(this.toByteArray());
    }

    public byte[] toByteArray() {
        ByteBuffer buffer = this.buffer();
        byte[] result = new byte[buffer.remaining()];
        buffer.get(result);
        return result;
    }

    public String asString() {
        try {
            return ByteBufferUtil.string(this.buffer(), StandardCharsets.UTF_8);
        }
        catch (CharacterCodingException e) {
            throw new RuntimeException(e);
        }
    }

    @VisibleForTesting
    final class GrowingChannel
    implements WritableByteChannel {
        GrowingChannel() {
        }

        @Override
        public int write(ByteBuffer src) {
            int count = src.remaining();
            DataOutputBuffer.this.expandToFit(count);
            DataOutputBuffer.this.buffer.put(src);
            return count;
        }

        @Override
        public boolean isOpen() {
            return true;
        }

        @Override
        public void close() {
        }
    }

    private static enum AllocationType {
        DIRECT,
        ONHEAP;

    }
}

