/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.io.sstable.format.bti;

import java.io.IOException;
import java.io.PrintStream;
import java.nio.ByteBuffer;
import javax.annotation.concurrent.NotThreadSafe;
import org.apache.cassandra.db.DeletionTime;
import org.apache.cassandra.io.sstable.format.Version;
import org.apache.cassandra.io.sstable.format.bti.TrieIndexEntry;
import org.apache.cassandra.io.tries.SerializationNode;
import org.apache.cassandra.io.tries.TrieNode;
import org.apache.cassandra.io.tries.TrieSerializer;
import org.apache.cassandra.io.tries.Walker;
import org.apache.cassandra.io.util.DataOutputPlus;
import org.apache.cassandra.io.util.FileHandle;
import org.apache.cassandra.io.util.SizedInts;
import org.apache.cassandra.utils.bytecomparable.ByteComparable;

@NotThreadSafe
public class RowIndexReader
extends Walker<RowIndexReader> {
    public final Version version;
    private static final int FLAG_OPEN_MARKER = 8;

    public RowIndexReader(FileHandle file, long root, Version version) {
        super(file.instantiateRebufferer(null), root);
        this.version = version;
    }

    public RowIndexReader(FileHandle file, TrieIndexEntry entry, Version version) {
        this(file, entry.indexTrieRoot, version);
    }

    public IndexInfo separatorFloor(ByteComparable key) throws IOException {
        IndexInfo res = this.prefixAndNeighbours(key, RowIndexReader::readPayload);
        if (res != null) {
            return res;
        }
        if (this.lesserBranch == (long)NONE) {
            return null;
        }
        this.goMax(this.lesserBranch);
        return this.getCurrentIndexInfo();
    }

    public IndexInfo min() throws IOException {
        this.goMin(this.root);
        return this.getCurrentIndexInfo();
    }

    protected IndexInfo getCurrentIndexInfo() throws IOException {
        return this.readPayload(this.payloadPosition(), this.payloadFlags());
    }

    protected IndexInfo readPayload(int ppos, int bits) throws IOException {
        return RowIndexReader.readPayload(this.buf, ppos, bits, this.version);
    }

    static IndexInfo readPayload(ByteBuffer buf, int ppos, int bits, Version version) throws IOException {
        if (bits == 0) {
            return null;
        }
        int bytes = bits & 0xFFFFFFF7;
        long dataOffset = SizedInts.read(buf, ppos, bytes);
        DeletionTime deletion = (bits & 8) != 0 ? DeletionTime.getSerializer(version).deserialize(buf, ppos += bytes) : null;
        return new IndexInfo(dataOffset, deletion);
    }

    static final TrieSerializer<IndexInfo, DataOutputPlus> getSerializer(final Version version) {
        return new TrieSerializer<IndexInfo, DataOutputPlus>(){

            @Override
            public int sizeofNode(SerializationNode<IndexInfo> node, long nodePosition) {
                return TrieNode.typeFor(node, nodePosition).sizeofNode(node) + this.sizeof(node.payload());
            }

            @Override
            public void write(DataOutputPlus dest, SerializationNode<IndexInfo> node, long nodePosition) throws IOException {
                this.write(dest, TrieNode.typeFor(node, nodePosition), node, nodePosition);
            }

            private int sizeof(IndexInfo payload) {
                int size = 0;
                if (payload != null) {
                    size += SizedInts.nonZeroSize(payload.offset);
                    if (!payload.openDeletion.isLive()) {
                        size = (int)((long)size + DeletionTime.getSerializer(version).serializedSize(payload.openDeletion));
                    }
                }
                return size;
            }

            private void write(DataOutputPlus dest, TrieNode type, SerializationNode<IndexInfo> node, long nodePosition) throws IOException {
                IndexInfo payload = node.payload();
                int bytes = 0;
                int hasOpenMarker = 0;
                if (payload != null) {
                    bytes = SizedInts.nonZeroSize(payload.offset);
                    assert (bytes < 8) : "Row index does not support rows larger than 32 PiB";
                    if (!payload.openDeletion.isLive()) {
                        hasOpenMarker = 8;
                    }
                }
                type.serialize(dest, node, bytes | hasOpenMarker, nodePosition);
                if (payload != null) {
                    SizedInts.write(dest, payload.offset, bytes);
                    if (hasOpenMarker == 8) {
                        DeletionTime.getSerializer(version).serialize(payload.openDeletion, dest);
                    }
                }
            }
        };
    }

    public void dumpTrie(PrintStream out) throws IOException {
        this.dumpTrie(out, RowIndexReader::dumpRowIndexEntry, this.version);
    }

    static String dumpRowIndexEntry(ByteBuffer buf, int ppos, int bits, Version version) throws IOException {
        IndexInfo ii = RowIndexReader.readPayload(buf, ppos, bits, version);
        return ii != null ? String.format("pos %x %s", ii.offset, ii.openDeletion == null ? "" : ii.openDeletion) : "pos null";
    }

    public static class IndexInfo {
        public final long offset;
        public final DeletionTime openDeletion;

        IndexInfo(long offset, DeletionTime openDeletion) {
            this.offset = offset;
            this.openDeletion = openDeletion;
        }
    }
}

