/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.cql3;

import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.cassandra.cql3.AbstractMarker;
import org.apache.cassandra.cql3.AssignmentTestable;
import org.apache.cassandra.cql3.ColumnIdentifier;
import org.apache.cassandra.cql3.ColumnSpecification;
import org.apache.cassandra.cql3.Constants;
import org.apache.cassandra.cql3.FieldIdentifier;
import org.apache.cassandra.cql3.Operation;
import org.apache.cassandra.cql3.QueryOptions;
import org.apache.cassandra.cql3.Term;
import org.apache.cassandra.cql3.Terms;
import org.apache.cassandra.cql3.UpdateParameters;
import org.apache.cassandra.cql3.VariableSpecifications;
import org.apache.cassandra.cql3.functions.Function;
import org.apache.cassandra.db.DecoratedKey;
import org.apache.cassandra.db.marshal.AbstractType;
import org.apache.cassandra.db.marshal.ByteBufferAccessor;
import org.apache.cassandra.db.marshal.TupleType;
import org.apache.cassandra.db.marshal.UserType;
import org.apache.cassandra.db.rows.CellPath;
import org.apache.cassandra.exceptions.InvalidRequestException;
import org.apache.cassandra.schema.ColumnMetadata;
import org.apache.cassandra.transport.ProtocolVersion;
import org.apache.cassandra.utils.ByteBufferUtil;

public abstract class UserTypes {
    private UserTypes() {
    }

    public static ColumnSpecification fieldSpecOf(ColumnSpecification column, int field) {
        UserType ut = (UserType)column.type.unwrap();
        return new ColumnSpecification(column.ksName, column.cfName, new ColumnIdentifier(column.name + "." + ut.fieldName(field), true), ut.fieldType(field));
    }

    public static <T extends AssignmentTestable> void validateUserTypeAssignableTo(ColumnSpecification receiver, Map<FieldIdentifier, T> entries) {
        if (!receiver.type.isUDT()) {
            throw new InvalidRequestException(String.format("Invalid user type literal for %s of type %s", receiver, receiver.type.asCQL3Type()));
        }
        UserType ut = (UserType)receiver.type;
        for (int i = 0; i < ut.size(); ++i) {
            ColumnSpecification fieldSpec;
            FieldIdentifier field = ut.fieldName(i);
            AssignmentTestable value = (AssignmentTestable)entries.get(field);
            if (value == null || value.testAssignment(receiver.ksName, fieldSpec = UserTypes.fieldSpecOf(receiver, i)).isAssignable()) continue;
            throw new InvalidRequestException(String.format("Invalid user type literal for %s: field %s is not of type %s", receiver, field, fieldSpec.type.asCQL3Type()));
        }
    }

    public static <T extends AssignmentTestable> AssignmentTestable.TestResult testUserTypeAssignment(ColumnSpecification receiver, Map<FieldIdentifier, T> entries) {
        try {
            UserTypes.validateUserTypeAssignableTo(receiver, entries);
            return AssignmentTestable.TestResult.WEAKLY_ASSIGNABLE;
        }
        catch (InvalidRequestException e) {
            return AssignmentTestable.TestResult.NOT_ASSIGNABLE;
        }
    }

    public static <T> String userTypeToString(Map<FieldIdentifier, T> items) {
        return UserTypes.userTypeToString(items, Object::toString);
    }

    public static <T> String userTypeToString(Map<FieldIdentifier, T> items, java.util.function.Function<T, String> mapper) {
        return items.entrySet().stream().map(p -> String.format("%s: %s", p.getKey(), mapper.apply(p.getValue()))).collect(Collectors.joining(", ", "{", "}"));
    }

    public static class DeleterByField
    extends Operation {
        private final FieldIdentifier field;

        public DeleterByField(ColumnMetadata column, FieldIdentifier field) {
            super(column, null);
            this.field = field;
        }

        @Override
        public void execute(DecoratedKey partitionKey, UpdateParameters params) throws InvalidRequestException {
            assert (this.column.type.isMultiCell()) : "Attempted to delete a single field from a frozen UDT";
            CellPath fieldPath = ((UserType)this.column.type).cellPathForField(this.field);
            params.addTombstone(this.column, fieldPath);
        }
    }

    public static class SetterByField
    extends Operation {
        private final FieldIdentifier field;

        public SetterByField(ColumnMetadata column, FieldIdentifier field, Term t2) {
            super(column, t2);
            this.field = field;
        }

        @Override
        public void execute(DecoratedKey partitionKey, UpdateParameters params) throws InvalidRequestException {
            assert (this.column.type.isMultiCell()) : "Attempted to set an individual field on a frozen UDT";
            Term.Terminal value = this.t.bind(params.options);
            if (value == Constants.UNSET_VALUE) {
                return;
            }
            CellPath fieldPath = ((UserType)this.column.type).cellPathForField(this.field);
            if (value == null) {
                params.addTombstone(this.column, fieldPath);
            } else {
                params.addCell(this.column, fieldPath, value.get(params.options.getProtocolVersion()));
            }
        }
    }

    public static class Setter
    extends Operation {
        public Setter(ColumnMetadata column, Term t2) {
            super(column, t2);
        }

        @Override
        public void execute(DecoratedKey partitionKey, UpdateParameters params) throws InvalidRequestException {
            Term.Terminal value = this.t.bind(params.options);
            if (value == Constants.UNSET_VALUE) {
                return;
            }
            Value userTypeValue = (Value)value;
            if (this.column.type.isMultiCell()) {
                params.setComplexDeletionTimeForOverwrite(this.column);
                if (value == null) {
                    return;
                }
                Iterator<FieldIdentifier> fieldNameIter = userTypeValue.type.fieldNames().iterator();
                for (ByteBuffer buffer : userTypeValue.elements) {
                    assert (fieldNameIter.hasNext());
                    FieldIdentifier fieldName = fieldNameIter.next();
                    if (buffer == null) continue;
                    CellPath fieldPath = userTypeValue.type.cellPathForField(fieldName);
                    params.addCell(this.column, fieldPath, buffer);
                }
            } else if (value == null) {
                params.addTombstone(this.column);
            } else {
                params.addCell(this.column, value.get(params.options.getProtocolVersion()));
            }
        }
    }

    public static class Marker
    extends AbstractMarker {
        protected Marker(int bindIndex, ColumnSpecification receiver) {
            super(bindIndex, receiver);
            assert (receiver.type.isUDT());
        }

        @Override
        public Term.Terminal bind(QueryOptions options) throws InvalidRequestException {
            ByteBuffer value = options.getValues().get(this.bindIndex);
            if (value == null) {
                return null;
            }
            if (value == ByteBufferUtil.UNSET_BYTE_BUFFER) {
                return Constants.UNSET_VALUE;
            }
            return Value.fromSerialized(value, (UserType)this.receiver.type);
        }
    }

    public static class DelayedValue
    extends Term.NonTerminal {
        private final UserType type;
        private final List<Term> values;

        public DelayedValue(UserType type, List<Term> values) {
            this.type = type;
            this.values = values;
        }

        @Override
        public void addFunctionsTo(List<Function> functions) {
            Terms.addFunctions(this.values, functions);
        }

        @Override
        public boolean containsBindMarker() {
            for (Term t2 : this.values) {
                if (!t2.containsBindMarker()) continue;
                return true;
            }
            return false;
        }

        @Override
        public void collectMarkerSpecification(VariableSpecifications boundNames) {
            for (int i = 0; i < this.type.size(); ++i) {
                this.values.get(i).collectMarkerSpecification(boundNames);
            }
        }

        private ByteBuffer[] bindInternal(QueryOptions options) throws InvalidRequestException {
            if (this.values.size() > this.type.size()) {
                throw new InvalidRequestException(String.format("UDT value contained too many fields (expected %s, got %s)", this.type.size(), this.values.size()));
            }
            ByteBuffer[] buffers = new ByteBuffer[this.values.size()];
            for (int i = 0; i < this.type.size(); ++i) {
                buffers[i] = this.values.get(i).bindAndGet(options);
                if (this.type.isMultiCell() || buffers[i] != ByteBufferUtil.UNSET_BYTE_BUFFER) continue;
                throw new InvalidRequestException(String.format("Invalid unset value for field '%s' of user defined type %s", this.type.fieldNameAsString(i), this.type.getNameAsString()));
            }
            return buffers;
        }

        @Override
        public Value bind(QueryOptions options) throws InvalidRequestException {
            return new Value(this.type, this.bindInternal(options));
        }

        @Override
        public ByteBuffer bindAndGet(QueryOptions options) throws InvalidRequestException {
            return UserType.buildValue(this.bindInternal(options));
        }
    }

    public static class Value
    extends Term.MultiItemTerminal {
        private final UserType type;
        public final ByteBuffer[] elements;

        public Value(UserType type, ByteBuffer[] elements) {
            this.type = type;
            this.elements = elements;
        }

        public static Value fromSerialized(ByteBuffer bytes, UserType type) {
            type.validate(bytes);
            return new Value(type, type.split(ByteBufferAccessor.instance, bytes));
        }

        @Override
        public ByteBuffer get(ProtocolVersion version) {
            return TupleType.buildValue(this.elements);
        }

        public boolean equals(UserType userType, Value v) {
            if (this.elements.length != v.elements.length) {
                return false;
            }
            for (int i = 0; i < this.elements.length; ++i) {
                if (userType.fieldType(i).compare(this.elements[i], v.elements[i]) == 0) continue;
                return false;
            }
            return true;
        }

        @Override
        public List<ByteBuffer> getElements() {
            return Arrays.asList(this.elements);
        }
    }

    public static class Literal
    extends Term.Raw {
        public final Map<FieldIdentifier, Term.Raw> entries;

        public Literal(Map<FieldIdentifier, Term.Raw> entries) {
            this.entries = entries;
        }

        @Override
        public Term prepare(String keyspace, ColumnSpecification receiver) throws InvalidRequestException {
            this.validateAssignableTo(keyspace, receiver);
            UserType ut = (UserType)receiver.type.unwrap();
            boolean allTerminal = true;
            ArrayList<Term> values = new ArrayList<Term>(this.entries.size());
            int foundValues = 0;
            for (int i = 0; i < ut.size(); ++i) {
                FieldIdentifier field = ut.fieldName(i);
                Term.Raw raw = this.entries.get(field);
                if (raw == null) {
                    raw = Constants.NULL_LITERAL;
                } else {
                    ++foundValues;
                }
                Term value = raw.prepare(keyspace, UserTypes.fieldSpecOf(receiver, i));
                if (value instanceof Term.NonTerminal) {
                    allTerminal = false;
                }
                values.add(value);
            }
            if (foundValues != this.entries.size()) {
                for (FieldIdentifier id : this.entries.keySet()) {
                    if (ut.fieldNames().contains(id)) continue;
                    throw new InvalidRequestException(String.format("Unknown field '%s' in value of user defined type %s", id, ut.getNameAsString()));
                }
            }
            DelayedValue value = new DelayedValue((UserType)receiver.type.unwrap(), values);
            return allTerminal ? value.bind(QueryOptions.DEFAULT) : value;
        }

        private void validateAssignableTo(String keyspace, ColumnSpecification receiver) throws InvalidRequestException {
            AbstractType<?> unwrapped = receiver.type.unwrap();
            if (!unwrapped.isUDT()) {
                throw new InvalidRequestException(String.format("Invalid user type literal for %s of type %s", receiver.name, receiver.type.asCQL3Type()));
            }
            UserType ut = (UserType)unwrapped;
            for (int i = 0; i < ut.size(); ++i) {
                ColumnSpecification fieldSpec;
                FieldIdentifier field = ut.fieldName(i);
                Term.Raw value = this.entries.get(field);
                if (value == null || value.testAssignment(keyspace, fieldSpec = UserTypes.fieldSpecOf(receiver, i)).isAssignable()) continue;
                throw new InvalidRequestException(String.format("Invalid user type literal for %s: field %s is not of type %s", receiver.name, field, fieldSpec.type.asCQL3Type()));
            }
        }

        @Override
        public AssignmentTestable.TestResult testAssignment(String keyspace, ColumnSpecification receiver) {
            return UserTypes.testUserTypeAssignment(receiver, this.entries);
        }

        @Override
        public AbstractType<?> getExactTypeIfKnown(String keyspace) {
            return null;
        }

        @Override
        public String getText() {
            return UserTypes.userTypeToString(this.entries, Term.Raw::getText);
        }
    }
}

