/*
 * Decompiled with CFR 0.152.
 */
package net.openhft.chronicle.queue;

import java.util.Arrays;
import net.openhft.chronicle.core.Maths;
import net.openhft.chronicle.core.time.TimeProvider;
import net.openhft.chronicle.queue.RollCycle;
import org.jetbrains.annotations.NotNull;

public final class RollCycles
extends Enum<RollCycles>
implements RollCycle {
    public static final /* enum */ RollCycles FIVE_MINUTELY = new RollCycles("yyyyMMdd-HHmm'V'", 300000, 2048, 256);
    public static final /* enum */ RollCycles TEN_MINUTELY = new RollCycles("yyyyMMdd-HHmm'X'", 600000, 2048, 256);
    public static final /* enum */ RollCycles TWENTY_MINUTELY = new RollCycles("yyyyMMdd-HHmm'XX'", 1200000, 2048, 256);
    public static final /* enum */ RollCycles HALF_HOURLY = new RollCycles("yyyyMMdd-HHmm'H'", 1800000, 2048, 256);
    public static final /* enum */ RollCycles FAST_HOURLY = new RollCycles("yyyyMMdd-HH'F'", 3600000, 4096, 256);
    public static final /* enum */ RollCycles TWO_HOURLY = new RollCycles("yyyyMMdd-HH'II'", 0x6DDD00, 4096, 256);
    public static final /* enum */ RollCycles FOUR_HOURLY = new RollCycles("yyyyMMdd-HH'IV'", 14400000, 4096, 256);
    public static final /* enum */ RollCycles SIX_HOURLY = new RollCycles("yyyyMMdd-HH'VI'", 21600000, 4096, 256);
    public static final /* enum */ RollCycles FAST_DAILY = new RollCycles("yyyyMMdd'F'", 86400000, 4096, 256);
    public static final /* enum */ RollCycles MINUTELY = new RollCycles("yyyyMMdd-HHmm", 60000, 2048, 16);
    public static final /* enum */ RollCycles HOURLY = new RollCycles("yyyyMMdd-HH", 3600000, 4096, 16);
    public static final /* enum */ RollCycles DAILY = new RollCycles("yyyyMMdd", 86400000, 8192, 64);
    public static final /* enum */ RollCycles LARGE_HOURLY = new RollCycles("yyyyMMdd-HH'L'", 3600000, 8192, 64);
    public static final /* enum */ RollCycles LARGE_DAILY = new RollCycles("yyyyMMdd'L'", 86400000, 32768, 128);
    public static final /* enum */ RollCycles XLARGE_DAILY = new RollCycles("yyyyMMdd'X'", 86400000, 32768, 256);
    public static final /* enum */ RollCycles HUGE_DAILY = new RollCycles("yyyyMMdd'H'", 86400000, 32768, 1024);
    public static final /* enum */ RollCycles SMALL_DAILY = new RollCycles("yyyyMMdd'S'", 86400000, 8192, 8);
    public static final /* enum */ RollCycles LARGE_HOURLY_SPARSE = new RollCycles("yyyyMMdd-HH'LS'", 3600000, 4096, 1024);
    public static final /* enum */ RollCycles LARGE_HOURLY_XSPARSE = new RollCycles("yyyyMMdd-HH'LX'", 3600000, 2048, 0x100000);
    public static final /* enum */ RollCycles HUGE_DAILY_XSPARSE = new RollCycles("yyyyMMdd'HX'", 86400000, 16384, 0x100000);
    public static final /* enum */ RollCycles TEST_SECONDLY = new RollCycles("yyyyMMdd-HHmmss'T'", 1000, 32768, 4);
    public static final /* enum */ RollCycles TEST4_SECONDLY = new RollCycles("yyyyMMdd-HHmmss'T4'", 1000, 32, 4);
    public static final /* enum */ RollCycles TEST_HOURLY = new RollCycles("yyyyMMdd-HH'T'", 3600000, 16, 4);
    public static final /* enum */ RollCycles TEST_DAILY = new RollCycles("yyyyMMdd'T1'", 86400000, 8, 1);
    public static final /* enum */ RollCycles TEST2_DAILY = new RollCycles("yyyyMMdd'T2'", 86400000, 16, 2);
    public static final /* enum */ RollCycles TEST4_DAILY = new RollCycles("yyyyMMdd'T4'", 86400000, 32, 4);
    public static final /* enum */ RollCycles TEST8_DAILY = new RollCycles("yyyyMMdd'T8'", 86400000, 128, 8);
    public static final RollCycles DEFAULT;
    private static final Iterable<RollCycles> VALUES;
    private final String format;
    private final int lengthInMillis;
    private final int cycleShift;
    private final int indexCount;
    private final int indexSpacing;
    private final long sequenceMask;
    private static final /* synthetic */ RollCycles[] $VALUES;

    public static RollCycles[] values() {
        return (RollCycles[])$VALUES.clone();
    }

    public static RollCycles valueOf(String name) {
        return Enum.valueOf(RollCycles.class, name);
    }

    private RollCycles(String format, int lengthInMillis, int indexCount, int indexSpacing) {
        this.format = format;
        this.lengthInMillis = lengthInMillis;
        this.indexCount = Maths.nextPower2(indexCount, 8);
        assert (this.indexCount <= 32768) : "indexCount: " + indexCount;
        this.indexSpacing = Maths.nextPower2(indexSpacing, 1);
        this.cycleShift = Math.max(32, Maths.intLog2(indexCount) * 2 + Maths.intLog2(indexSpacing));
        assert (this.cycleShift < 64) : "cycleShift: " + this.cycleShift;
        this.sequenceMask = (1L << this.cycleShift) - 1L;
    }

    public static Iterable<RollCycles> all() {
        return VALUES;
    }

    public static long maxMessagesPerCycle(long indexCount0, int indexSpacing0) {
        long indexCount = Maths.nextPower2(indexCount0, 8L);
        int indexSpacing = Maths.nextPower2(indexSpacing0, 1);
        int cycleShift = Math.max(32, Maths.intLog2(indexCount) * 2 + Maths.intLog2(indexSpacing));
        long sequenceMask0 = (1L << cycleShift) - 1L;
        return Math.min(sequenceMask0, indexCount * indexCount * (long)indexSpacing);
    }

    @Override
    public long maxMessagesPerCycle() {
        return RollCycles.maxMessagesPerCycle(this.indexCount, this.indexSpacing);
    }

    @Override
    public String format() {
        return this.format;
    }

    @Override
    public int lengthInMillis() {
        return this.lengthInMillis;
    }

    @Override
    public int defaultIndexCount() {
        return this.indexCount;
    }

    @Override
    public int defaultIndexSpacing() {
        return this.indexSpacing;
    }

    @Override
    public int current(@NotNull TimeProvider time, long epoch) {
        return (int)((time.currentTimeMillis() - epoch) / (long)this.lengthInMillis());
    }

    @Override
    public long toIndex(int cycle, long sequenceNumber) {
        return ((long)cycle << this.cycleShift) + (sequenceNumber & this.sequenceMask);
    }

    @Override
    public long toSequenceNumber(long index) {
        return index & this.sequenceMask;
    }

    @Override
    public int toCycle(long index) {
        return Maths.toUInt31(index >> this.cycleShift);
    }

    static {
        $VALUES = new RollCycles[]{FIVE_MINUTELY, TEN_MINUTELY, TWENTY_MINUTELY, HALF_HOURLY, FAST_HOURLY, TWO_HOURLY, FOUR_HOURLY, SIX_HOURLY, FAST_DAILY, MINUTELY, HOURLY, DAILY, LARGE_HOURLY, LARGE_DAILY, XLARGE_DAILY, HUGE_DAILY, SMALL_DAILY, LARGE_HOURLY_SPARSE, LARGE_HOURLY_XSPARSE, HUGE_DAILY_XSPARSE, TEST_SECONDLY, TEST4_SECONDLY, TEST_HOURLY, TEST_DAILY, TEST2_DAILY, TEST4_DAILY, TEST8_DAILY};
        DEFAULT = FAST_DAILY;
        VALUES = Arrays.asList(RollCycles.values());
    }
}

