/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.secrets;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Base64;
import java.util.Map;
import java.util.Objects;
import org.apache.cassandra.secrets.SecretsProvider;
import org.apache.cassandra.secrets.SslConfig;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SslConfigSecretsProvider
implements SecretsProvider {
    private static final Logger LOGGER = LoggerFactory.getLogger(SslConfigSecretsProvider.class);
    private final SslConfig config;

    public SslConfigSecretsProvider(SslConfig config) {
        this.config = config;
    }

    @Override
    public void initialize(@NotNull Map<String, String> environmentOptions) {
    }

    @Override
    public boolean hasKeyStoreSecrets() {
        String keyStorePath = this.config.keyStorePath();
        if (keyStorePath != null) {
            return Files.exists(Paths.get(keyStorePath, new String[0]), new LinkOption[0]) && this.keyStorePassword() != null;
        }
        return this.config.base64EncodedKeyStore() != null && !this.config.base64EncodedKeyStore().isEmpty();
    }

    @Override
    public InputStream keyStoreInputStream() throws IOException {
        if (this.config.keyStorePath() != null) {
            return Files.newInputStream(Paths.get(this.config.keyStorePath(), new String[0]), new OpenOption[0]);
        }
        if (this.config.base64EncodedKeyStore() != null) {
            return new ByteArrayInputStream(Base64.getDecoder().decode(this.config.base64EncodedKeyStore()));
        }
        throw new RuntimeException("keyStorePath or encodedKeyStore must be provided");
    }

    @Override
    public char[] keyStorePassword() {
        return Objects.requireNonNull(this.config.keyStorePassword(), "keyStorePassword must be not null").toCharArray();
    }

    @Override
    public String keyStoreType() {
        return this.config.keyStoreType();
    }

    @Override
    public boolean hasTrustStoreSecrets() {
        String trustStorePath = this.config.trustStorePath();
        if (trustStorePath != null) {
            return Files.exists(Paths.get(trustStorePath, new String[0]), new LinkOption[0]) && this.trustStorePassword() != null;
        }
        return this.config.base64EncodedTrustStore() != null && !this.config.base64EncodedTrustStore().isEmpty();
    }

    @Override
    public InputStream trustStoreInputStream() throws IOException {
        if (this.config.trustStorePath() != null) {
            return Files.newInputStream(Paths.get(this.config.trustStorePath(), new String[0]), new OpenOption[0]);
        }
        if (this.config.base64EncodedTrustStore() != null) {
            return new ByteArrayInputStream(Base64.getDecoder().decode(this.config.base64EncodedTrustStore()));
        }
        return null;
    }

    @Override
    public char[] trustStorePassword() {
        String password = this.config.trustStorePassword();
        return password != null ? password.toCharArray() : null;
    }

    @Override
    public String trustStoreType() {
        return this.config.trustStoreType();
    }

    @Override
    public void validateMutualTLS() {
        String trustStorePath;
        boolean fail = false;
        String keyStorePath = this.config.keyStorePath();
        if (keyStorePath != null) {
            if (!Files.exists(Paths.get(keyStorePath, new String[0]), new LinkOption[0])) {
                LOGGER.warn("Provided keystore path option does not exist in the file system keystorePath={}", (Object)keyStorePath);
                fail = true;
            }
        } else if (this.config.base64EncodedKeyStore() == null || this.config.base64EncodedKeyStore().isEmpty()) {
            LOGGER.warn("Neither keystore path or encoded keystore options were provided");
            fail = true;
        }
        if (this.keyStorePassword() == null) {
            LOGGER.warn("No keystore password option provided");
        }
        if ((trustStorePath = this.config.trustStorePath()) != null && !Files.exists(Paths.get(trustStorePath, new String[0]), new LinkOption[0])) {
            LOGGER.warn("Provided truststore path option does not exist in the file system trustStorePath={}", (Object)trustStorePath);
            fail = true;
        }
        if ((trustStorePath != null || this.config.base64EncodedTrustStore() != null) && this.trustStorePassword() == null) {
            LOGGER.warn("No truststore password option provided");
            fail = true;
        }
        if (fail) {
            throw new RuntimeException("No valid keystore/password provided in options");
        }
    }

    @Override
    public String secretByName(String secretName) {
        throw new UnsupportedOperationException("Currently not supported");
    }

    @Override
    public Path secretsPath() {
        return this.config.secretsPath() != null ? Paths.get(this.config.secretsPath(), new String[0]) : null;
    }

    public String toString() {
        return "SecretsConfigProvider{config=" + String.valueOf(this.config) + "}";
    }
}

