/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.cdc.state;

import com.esotericsoftware.kryo.Kryo;
import com.esotericsoftware.kryo.io.Input;
import com.esotericsoftware.kryo.io.Output;
import com.google.common.collect.ImmutableMap;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import org.apache.cassandra.bridge.TokenRange;
import org.apache.cassandra.cdc.api.CdcOptions;
import org.apache.cassandra.cdc.api.CommitLogMarkers;
import org.apache.cassandra.cdc.api.Marker;
import org.apache.cassandra.cdc.api.PerInstanceCommitLogMarkers;
import org.apache.cassandra.cdc.api.PerRangeCommitLogMarkers;
import org.apache.cassandra.cdc.stats.ICdcStats;
import org.apache.cassandra.db.commitlog.PartitionUpdateWrapper;
import org.apache.cassandra.spark.data.partitioner.CassandraInstance;
import org.apache.cassandra.spark.utils.KryoUtils;
import org.apache.cassandra.util.CompressionUtil;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class CdcState {
    public static final Serializer SERIALIZER = new Serializer();
    public static final ReplicaCountSerializer REPLICA_COUNT_SERIALIZER = new ReplicaCountSerializer();
    public static final CdcState BLANK = CdcState.blank(null);
    public final long epoch;
    @Nullable
    public final TokenRange range;
    @NotNull
    public final CommitLogMarkers markers;
    @NotNull
    public final Map<PartitionUpdateWrapper.Digest, Integer> replicaCount;

    public CdcState(long epoch, @Nullable TokenRange range, @NotNull CommitLogMarkers markers, @NotNull Map<PartitionUpdateWrapper.Digest, Integer> replicaCount) {
        this.epoch = epoch;
        this.range = range;
        this.markers = markers;
        this.replicaCount = ImmutableMap.copyOf(replicaCount);
    }

    public int size() {
        return this.replicaCount.size();
    }

    public static CdcState blank(@Nullable TokenRange range) {
        return new CdcState(0L, range, CommitLogMarkers.EMPTY, (Map<PartitionUpdateWrapper.Digest, Integer>)ImmutableMap.of());
    }

    public static CdcState of(long epoch) {
        return CdcState.of(epoch, null);
    }

    public static CdcState of(long epoch, @Nullable TokenRange range) {
        return CdcState.of(epoch, range, CommitLogMarkers.EMPTY, (Map<PartitionUpdateWrapper.Digest, Integer>)ImmutableMap.of());
    }

    public static CdcState of(long epoch, @Nullable TokenRange range, @NotNull CommitLogMarkers markers, @NotNull Map<PartitionUpdateWrapper.Digest, Integer> replicaCount) {
        return new CdcState(epoch, range, markers, replicaCount);
    }

    public CdcState merge(@Nullable TokenRange range, CdcState other) {
        return CdcState.merge(range, this, other);
    }

    public Mutator mutate() {
        return new Mutator(this);
    }

    public boolean isFull(CdcOptions cdcOptions) {
        int maxCdcStateSize = cdcOptions.maxCdcStateSize();
        return maxCdcStateSize > 0 && this.size() >= maxCdcStateSize;
    }

    public CdcState purgeIfFull(ICdcStats stats, CdcOptions cdcOptions) {
        if (this.isFull(cdcOptions)) {
            return this.mutate().purge(stats, cdcOptions.minimumTimestampMicros()).build();
        }
        return this;
    }

    public String toString() {
        return "CdcState{epoch=" + this.epoch + ", range=" + String.valueOf(this.range) + ", markers=" + String.valueOf(this.markers) + ", replicaCount=" + String.valueOf(this.replicaCount) + "}";
    }

    public static boolean isExpired(@NotNull PartitionUpdateWrapper.Digest update, long minTimestampMicros) {
        return update.maxTimestampMicros() < minTimestampMicros;
    }

    public static CdcState merge(@Nullable TokenRange range, CdcState state1, CdcState state2) {
        return new CdcState(Math.max(state1.epoch, state2.epoch), range, CdcState.mergeMarkers(state1, state2), CdcState.mergeReplicaCount(state1.replicaCount, state2.replicaCount));
    }

    public static Map<PartitionUpdateWrapper.Digest, Integer> mergeReplicaCount(Map<PartitionUpdateWrapper.Digest, Integer> w1, Map<PartitionUpdateWrapper.Digest, Integer> w2) {
        HashMap<PartitionUpdateWrapper.Digest, Integer> mergedMap = new HashMap<PartitionUpdateWrapper.Digest, Integer>(w1);
        for (Map.Entry<PartitionUpdateWrapper.Digest, Integer> entry : w2.entrySet()) {
            mergedMap.merge(entry.getKey(), entry.getValue(), Math::max);
        }
        return mergedMap;
    }

    public static CommitLogMarkers mergeMarkers(@NotNull CdcState state1, @NotNull CdcState state2) {
        return CdcState.mergeMarkers(state1.markers, state1.range, state2.markers, state2.range);
    }

    public static CommitLogMarkers mergeMarkers(@NotNull CommitLogMarkers markers1, @Nullable TokenRange range1, @NotNull CommitLogMarkers markers2, @Nullable TokenRange range2) {
        if (range1 == null || range2 == null) {
            return CommitLogMarkers.of(markers1, markers2);
        }
        PerRangeCommitLogMarkers.PerRangeBuilder builder = CommitLogMarkers.perRangeBuilder();
        markers1.values().forEach(marker -> builder.add(range1, (Marker)marker));
        markers2.values().forEach(marker -> builder.add(range2, (Marker)marker));
        return builder.build();
    }

    public int hashCode() {
        return Objects.hash(this.epoch, this.range, this.markers, this.replicaCount);
    }

    public boolean equals(Object other) {
        if (other == this) {
            return true;
        }
        if (!(other instanceof CdcState)) {
            return false;
        }
        CdcState that = (CdcState)other;
        return this.epoch == that.epoch && Objects.equals(this.range, that.range) && Objects.equals(this.markers, that.markers) && Objects.equals(this.replicaCount, that.replicaCount);
    }

    public static CdcState deserialize(Kryo kryo, CompressionUtil compressionUtil, byte[] compressed) {
        try {
            return KryoUtils.deserialize(kryo, compressionUtil.uncompress(compressed), CdcState.class, SERIALIZER);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public static class ReplicaCountSerializer
    extends com.esotericsoftware.kryo.Serializer<Map<PartitionUpdateWrapper.Digest, Integer>> {
        public Map<PartitionUpdateWrapper.Digest, Integer> read(Kryo kryo, Input in, Class type) {
            int numUpdates = in.readShort();
            HashMap<PartitionUpdateWrapper.Digest, Integer> replicaCounts = new HashMap<PartitionUpdateWrapper.Digest, Integer>(numUpdates);
            for (int i = 0; i < numUpdates; ++i) {
                replicaCounts.put((PartitionUpdateWrapper.Digest)kryo.readObject(in, PartitionUpdateWrapper.Digest.class, (com.esotericsoftware.kryo.Serializer)PartitionUpdateWrapper.DIGEST_SERIALIZER), Integer.valueOf(in.readByte()));
            }
            return replicaCounts;
        }

        public void write(Kryo kryo, Output out, Map<PartitionUpdateWrapper.Digest, Integer> o) {
            out.writeShort(o.size());
            for (Map.Entry<PartitionUpdateWrapper.Digest, Integer> entry : o.entrySet()) {
                PartitionUpdateWrapper.Digest digest = entry.getKey();
                kryo.writeObject(out, (Object)digest, (com.esotericsoftware.kryo.Serializer)PartitionUpdateWrapper.DIGEST_SERIALIZER);
                out.writeByte(entry.getValue().intValue());
            }
        }
    }

    public static class Serializer
    extends com.esotericsoftware.kryo.Serializer<CdcState> {
        public void write(Kryo kryo, Output out, CdcState state) {
            out.writeLong(state.epoch);
            KryoUtils.writeRange(out, state.range);
            kryo.writeObject(out, (Object)state.markers, (com.esotericsoftware.kryo.Serializer)CommitLogMarkers.SERIALIZER);
            kryo.writeObject(out, state.replicaCount, (com.esotericsoftware.kryo.Serializer)REPLICA_COUNT_SERIALIZER);
        }

        public CdcState read(Kryo kryo, Input in, Class<CdcState> type) {
            long epoch = in.readLong();
            TokenRange range = KryoUtils.readRange(in);
            CommitLogMarkers markers = (CommitLogMarkers)kryo.readObject(in, CommitLogMarkers.class, (com.esotericsoftware.kryo.Serializer)CommitLogMarkers.SERIALIZER);
            Map replicaCount = (Map)kryo.readObject(in, Map.class, (com.esotericsoftware.kryo.Serializer)REPLICA_COUNT_SERIALIZER);
            return new CdcState(epoch, range, markers, replicaCount);
        }
    }

    public static class Mutator {
        @NotNull
        private final CdcState start;
        private long epoch;
        @NotNull
        private final PerInstanceCommitLogMarkers.PerInstanceBuilder markerBuilder;
        @Nullable
        private TokenRange range;
        @NotNull
        private final Map<PartitionUpdateWrapper.Digest, Integer> replicaCount;

        private Mutator(@NotNull CdcState start) {
            this.start = start;
            this.epoch = start.epoch;
            this.range = start.range;
            this.markerBuilder = start.markers.mutate();
            this.replicaCount = new HashMap<PartitionUpdateWrapper.Digest, Integer>(start.replicaCount);
        }

        public Mutator advanceMarker(CassandraInstance instance, Marker marker) {
            this.markerBuilder.advanceMarker(instance, marker);
            return this;
        }

        public int replicaCount(PartitionUpdateWrapper update) {
            return this.replicaCount(update.digest());
        }

        public int replicaCount(PartitionUpdateWrapper.Digest digest) {
            return this.replicaCount.getOrDefault(digest, 0);
        }

        public Mutator recordReplicaCount(PartitionUpdateWrapper updateWrapper, int replicaCount) {
            this.replicaCount.put(updateWrapper.digest(), replicaCount);
            return this;
        }

        public Mutator untrackReplicaCount(PartitionUpdateWrapper update) {
            return this.untrackReplicaCount(update.digest());
        }

        public Mutator untrackReplicaCount(PartitionUpdateWrapper.Digest digest) {
            this.replicaCount.remove(digest);
            return this;
        }

        public boolean seenBefore(PartitionUpdateWrapper update) {
            return this.seenBefore(update.digest());
        }

        public boolean seenBefore(PartitionUpdateWrapper.Digest digest) {
            return this.start.replicaCount.containsKey(digest);
        }

        public int size() {
            return this.replicaCount.size();
        }

        public boolean isFull(CdcOptions cdcOptions) {
            int maxCdcStateSize = cdcOptions.maxCdcStateSize();
            return maxCdcStateSize > 0 && this.size() >= maxCdcStateSize;
        }

        public Mutator nextEpoch() {
            ++this.epoch;
            return this;
        }

        public Mutator withRange(@Nullable TokenRange range) {
            this.range = range;
            return this;
        }

        public Mutator purge(ICdcStats cdcStats, @Nullable Long startTimestampMicros) {
            if (startTimestampMicros == null) {
                return this;
            }
            int[] count = new int[]{0};
            this.replicaCount.keySet().removeIf(update -> {
                if (CdcState.isExpired(update, startTimestampMicros)) {
                    count[0] = count[0] + 1;
                    return true;
                }
                return false;
            });
            cdcStats.droppedExpiredMutations(startTimestampMicros, count[0]);
            return this;
        }

        public CdcState build() {
            return new CdcState(this.epoch, this.range, this.markerBuilder.build(), this.replicaCount);
        }
    }
}

