/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.spark.bulkwriter.cloudstorage.coordinated;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.JavaType;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.type.MapType;
import com.fasterxml.jackson.databind.type.TypeFactory;
import com.google.common.base.Preconditions;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Set;
import java.util.stream.Collectors;
import o.a.c.sidecar.client.shaded.client.SidecarInstance;
import org.apache.cassandra.spark.bulkwriter.token.ConsistencyLevel;
import org.apache.cassandra.spark.common.SidecarInstanceFactory;
import org.apache.commons.lang3.StringUtils;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CoordinatedWriteConf {
    private static final Logger LOGGER = LoggerFactory.getLogger(CoordinatedWriteConf.class);
    private static final ObjectMapper OBJECT_MAPPER = new ObjectMapper();
    private final Map<String, ClusterConf> clusters;
    private final String rawJson;

    public static <T extends ClusterConf> CoordinatedWriteConf create(String json, ConsistencyLevel.CL consistencyLevel, Class<T> clusterConfType) {
        CoordinatedWriteConf result;
        MapType javaType = TypeFactory.defaultInstance().constructMapType(Map.class, String.class, clusterConfType);
        try {
            result = new CoordinatedWriteConf(json, (Map)OBJECT_MAPPER.readValue(json, (JavaType)javaType));
        }
        catch (Exception e) {
            throw new IllegalArgumentException("Unable to parse json string into CoordinatedWriteConf of " + clusterConfType.getSimpleName() + " due to " + e.getMessage(), e);
        }
        result.clusters().forEach((clusterId, cluster) -> {
            if (consistencyLevel.isLocal()) {
                Preconditions.checkState((!StringUtils.isEmpty((CharSequence)cluster.localDc()) ? 1 : 0) != 0, (Object)("localDc is not configured for cluster: " + clusterId + " for consistency level: " + String.valueOf(consistencyLevel)));
            } else if (cluster.localDc() != null) {
                LOGGER.warn("Ignoring the localDc configured for cluster, when consistency level is non-local. cluster={} consistencyLevel={}", clusterId, (Object)consistencyLevel);
            }
        });
        return result;
    }

    public CoordinatedWriteConf(Map<String, ? extends ClusterConf> clusters) {
        this.clusters = Collections.unmodifiableMap(clusters);
        try {
            this.rawJson = OBJECT_MAPPER.writeValueAsString(clusters);
        }
        catch (JsonProcessingException e) {
            throw new IllegalArgumentException("Input cannot be written as json string", e);
        }
    }

    public CoordinatedWriteConf(String rawJson, Map<String, ? extends ClusterConf> clusters) {
        this.rawJson = rawJson;
        this.clusters = Collections.unmodifiableMap(clusters);
    }

    public Map<String, ClusterConf> clusters() {
        return this.clusters;
    }

    @NotNull
    public ClusterConf cluster(String clusterId) {
        ClusterConf cluster = this.clusters.get(clusterId);
        if (cluster == null) {
            throw new NoSuchElementException("No ClusterConf is found for clusterId: " + clusterId);
        }
        return cluster;
    }

    public <T extends ClusterConf> Map<String, T> clustersOf(Class<T> clusterConfType) {
        this.clusters.values().forEach(v -> Preconditions.checkState((boolean)clusterConfType.isInstance(v), (Object)("ClusterConfProvider value is not instance of " + String.valueOf(clusterConfType))));
        return this.clusters;
    }

    public String toJson() {
        return this.rawJson;
    }

    public String toString() {
        return "CoordinatedWriteConf{json=" + this.rawJson + "}";
    }

    @JsonIgnoreProperties(ignoreUnknown=true)
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public static class SimpleClusterConf
    implements ClusterConf {
        private final List<String> sidecarContactPointsValue;
        private final Set<SidecarInstance> sidecarContactPoints;
        @Nullable
        private final String localDc;
        private final boolean writeToLocalDcOnly;

        @JsonCreator
        public SimpleClusterConf(@JsonProperty(value="sidecarContactPoints") List<String> sidecarContactPointsValue, @JsonProperty(value="localDc") String localDc, @JsonProperty(value="writeToLocalDcOnly") boolean writeToLocalDcOnly) {
            this.sidecarContactPointsValue = sidecarContactPointsValue;
            this.sidecarContactPoints = this.buildSidecarContactPoints(sidecarContactPointsValue);
            this.localDc = localDc;
            this.writeToLocalDcOnly = writeToLocalDcOnly;
        }

        public SimpleClusterConf(List<String> sidecarContactPointsValue, String localDc) {
            this(sidecarContactPointsValue, localDc, false);
        }

        @JsonProperty(value="sidecarContactPoints")
        public List<String> sidecarContactPointsValue() {
            return this.sidecarContactPointsValue;
        }

        @Override
        @JsonProperty(value="localDc")
        @Nullable
        public String localDc() {
            return this.localDc;
        }

        @Override
        @JsonProperty(value="writeToLocalDcOnly")
        public boolean writeToLocalDcOnly() {
            return this.writeToLocalDcOnly;
        }

        @Override
        public Set<SidecarInstance> sidecarContactPoints() {
            return this.sidecarContactPoints;
        }

        private Set<SidecarInstance> buildSidecarContactPoints(List<String> sidecarContactPoints) {
            return sidecarContactPoints.stream().filter(StringUtils::isNotEmpty).map(SidecarInstanceFactory::createFromString).collect(Collectors.collectingAndThen(Collectors.toSet(), Collections::unmodifiableSet));
        }
    }

    public static interface ClusterConf {
        public Set<SidecarInstance> sidecarContactPoints();

        @Nullable
        public String localDc();

        public boolean writeToLocalDcOnly();

        @Nullable
        default public String resolveLocalDc(ConsistencyLevel cl) {
            boolean hasLocalDc;
            String localDc = this.localDc();
            boolean bl = hasLocalDc = !StringUtils.isEmpty((CharSequence)this.localDc());
            if (!cl.isLocal() && hasLocalDc) {
                return null;
            }
            if (cl.isLocal() && !hasLocalDc) {
                throw new IllegalStateException("No localDc is specified for local consistency level: " + String.valueOf(cl));
            }
            return localDc;
        }
    }
}

